/* =========================== START PROC GPLKD2 ======================== */
PROC GPLKD2(DATA,XGRID,VH,HTYPE,IKER,KPAR) ;
   /*  LOCAL KERNEL DENSITY ESTIMATE   */
   /*  A DIRECT IMPLEMENTATION, HENCE RATHER SLOW   */
   /*  A MODIFICATION OF GPLKD1, INTENDED TO HANDLE LARGER  */
   /*  DATA SETS, THROUGH A LOOP THROUGH GRID POINTS   */
   /*  DATA IS A COLUMN VECTOR OF POINTS FROM DESIRED DENSITY  */
   /*  XGRID IS A COLUMN VECTOR OF PLACES TO EVALUTATE   */
   /*  VH IS A COLUMN VECTOR OF BANDWIDTHS     */
   /*  HTYPE = 1   -   BANDWIDTH DEPENDING ON x   */
   /*                LENGTH OF VH SAME AS XGRID    */
   /*  HTYPE = 2   -   BANDWIDTH DEPENDING ON X_i   */
   /*                LENGTH OF VH SAME AS DATA    */
   /*  IKER = 1  -  STANDARD NORMAL   */
   /*            KPAR HAS NO EFFECT   */
   /*  IKER = 2  -  BETA, SUPPORTED [-1,1], WITH  */
   /*            KPAR = 0  -  UNIFORM   */
   /*            KPAR = 1  -  EPANECHNIKOV   */
   /*            KPAR = 2  -  BIWEIGHT   */
   /*            KPAR = 3  -  TRIWEIGHT   */
   /*  OUTPUT IS A VECTOR OF HEIGHTS OF THE ESTIMATE, AT XGRID  */

 LOCAL NOBS,NXG,IXG,ARG,FHAT,CONST ;

 NOBS = ROWS(DATA) ;
 NXG = ROWS(XGRID) ;

 FHAT = ZEROS(NXG,1) ;

 IXG = 1 ;
 DO WHILE IXG <= NXG ;
   "." ;;

   ARG = DATA - XGRID[IXG] ;

   IF HTYPE == 1 ;
     ARG = ARG ./ VH[IXG] ;
   ELSEIF HTYPE == 2 ;
     ARG = ARG ./ VH ;
   ENDIF ;


   IF IKER == 1 ;        /*  WORK WITH GAUSSIAN FAMILY  */
     ARG = PDFN(ARG) ;
     CONST = 1 ;
   ELSEIF IKER == 2 ;    /*  WORK WITH BETA FAMILY  */

     IF KPAR == 0 ;      /*  UNIFORM KERNEL  */
       ARG = (ABS(ARG) .<= 1) ;
       CONST = (1 / 2) ;              /*  CONSTANT FROM MARRON-NOLAN  */
     ELSE ;
       ARG = 1 - ARG .* ARG ;
       ARG = ARG .* (ARG .> 0) ;
       IF KPAR == 1 ;     /*  EPANECHNIKOV KERNEL  */
         CONST = (3 / 4) ;            /*  CONSTANT FROM MARRON-NOLAN  */
       ELSEIF KPAR == 2 ;    /*  BIWEIGHT KERNEL  */
         ARG = ARG .* ARG ;
         CONST = (15 / 16) ;         /*  CONSTANT FROM MARRON-NOLAN  */
       ELSEIF KPAR == 3 ;    /*  TRIWEIGHT KERNEL  */
         ARG = ARG .* ARG .* ARG ;
         CONST = (35 / 32) ;         /*  CONSTANT FROM MARRON-NOLAN  */
       ELSE ;               /*  USE MARRON-NOLAN GENERAL FORMULA  */
         ARG = ARG^KPAR ;
         CONST = (GAMMA(2*KPAR+2) * GAMMA(KPAR+1)^(-2) * 2^(-2*KPAR-1)) ;
       ENDIF ;
     ENDIF ;

   ENDIF ;


   IF HTYPE == 1 ;
     ARG = ARG ./ VH[IXG] ;
   ELSEIF HTYPE == 2 ;
     ARG = ARG ./ VH ;
   ENDIF ;

   FHAT[IXG] = SUMC(ARG) ;

   IXG = IXG + 1 ;
 ENDO ; ? ;


 FHAT = FHAT * CONST ;
 FHAT = FHAT / NOBS ;

 RETP(FHAT) ;
ENDP ;
/* ============================ END PROC GPLKD2 ======================== */
