/* =========================== START PROC GPLLR1 ======================== */
PROC GPLLR1(DATA,LEFT,RIGHT,NXGRID,H,IKER,KPAR) ;
   /*  DIRECT MATRIX CALCULATION OF LOCAL LINEAR REGRESSION ESTIMATE  */
   /*  ALGORITHM HERE IS A LOOP THROUGH THE DATA POINTS  */
   /*     caution: SHOULD USED BINNED VERSION BNLLR1.G FOR SPEED  */
   /*  ON AN EQUALLY SPACED GRID OF NXGRID POINTS,   */
   /*      EQUALLY SPACED FROM LEFT TO RIGHT  */
   /*  DATA IS MATRIX WHERE THE FIRST COLUMN ARE THE X'S  */
   /*      AND THE SECOND COLUMN ARE THE Y'S  */
   /*  H IS THE BANDWIDTH, MUST BE A SCALAR    */
   /*  IKER = 1  -  GAUSSIAN               */
   /*            KPAR HAS NO EFFECT   */
   /*  IKER = 2  -  BETA, SUPPORTED [-1,1], WITH  */
   /*            KPAR = 0  -  UNIFORM   */
   /*            KPAR = 1  -  EPANECHNIKOV   */
   /*            KPAR = 2  -  BIWEIGHT   */
   /*            KPAR = 3  -  TRIWEIGHT   */
   /*  OUTPUT IS A MATRIX,       */
   /*  FIRST COLUMN IS HEIGHTS OF THE ESTIMATE, AT BIN CENTERS  */
   /*  SECOND COLUMN IS THE KERNEL FUNCTION USED   */
   /*  CAUTION, KERNEL ONLY GIVES SHAPE AND WILL NEED RESCALING  */

 LOCAL NOBS,XGRID,MDATA,MH,VIS,VIE,IOBS,S0,S1,S2,SY0,SY1,
           ARG,IS,KVEC,IE,DENOM ;

 NOBS = ROWS(DATA) ;

 XGRID = SEQA(LEFT,(RIGHT - LEFT) / (NXGRID - 1),NXGRID) ;

 IF IKER == 2 ;
   MDATA = ((NXGRID - 1) * (DATA[.,1] - LEFT) / (RIGHT - LEFT)) + 1 ;
                  /*  MAP DATA IN [LEFT,RIGHT] TO INTERVAL [1, NXGRID]  */
   MH = ((NXGRID - 1) * H / (RIGHT - LEFT)) ;
                  /*  MAP H ON [LEFT,RIGHT] TO INTERVAL [1, NXGRID]  */
   VIS = CEIL(MDATA - MH) ;      /*  VECTOR OF STARTING POINTS  */
   VIS = MAXC(VIS'|ONES(1,NOBS)) ;
   VIE = FLOOR(MDATA + MH) ;      /*  VECTOR OF ENDING POINTS  */
   VIE = MINC(VIE'|(NXGRID*ONES(1,NOBS))) ;
     MDATA = 0 ;          /*  TO SAVE SPACE  */
 ENDIF ;


 IOBS = 1 ;
 S0 = ZEROS(NXGRID,1) ;
 S1 = ZEROS(NXGRID,1) ;
 S2 = ZEROS(NXGRID,1) ;
 SY0 = ZEROS(NXGRID,1) ;
 SY1 = ZEROS(NXGRID,1) ;
 DO WHILE IOBS <= NOBS ;
   "." ;;

   IF IKER == 1 ;
     ARG = (XGRID - DATA[IOBS,1]) / H ;
     KVEC = PDFN(ARG) ;

     S0 = S0 + KVEC ;
     S1 = S1 + KVEC .* (ARG .* H) ;
     S2 = S2 + KVEC .* (ARG .* H) .* (ARG .* H) ;
     SY0 = SY0 + KVEC .* DATA[IOBS,2] ;
     SY1 = SY1 + KVEC .* (ARG .* H) .* DATA[IOBS,2] ;
   ELSEIF IKER == 2 ;
     IS = VIS[IOBS] ;
     IE = VIE[IOBS] ;
     ARG = (XGRID[IS:IE,1] - DATA[IOBS,1]) / H ;
     IF IS <= IE ;    /*  IF DATA POINT IS WITHIN H OF INTERVAL  */
       IF KPAR == 0 ;      /*  UNIFORM KERNEL  */
         KVEC = ONES(IE-IS+1,1) ;
         KVEC = KVEC * (1 / 2) ;           /*  CONSTANT FROM MARRON-NOLAN  */
       ELSE ;
         KVEC = 1 - ARG .* ARG ;
         IF KPAR == 1 ;     /*  EPANECHNIKOV KERNEL  */
           KVEC = KVEC * (3 / 4) ;         /*  CONSTANT FROM MARRON-NOLAN  */
         ELSEIF KPAR == 2 ;    /*  BIWEIGHT KERNEL  */
           KVEC = KVEC .* KVEC ;
           KVEC = KVEC .* (15 / 16) ;      /*  CONSTANT FROM MARRON-NOLAN  */
         ELSEIF KPAR == 3 ;    /*  TRIWEIGHT KERNEL  */
           KVEC = KVEC .* KVEC .* KVEC ;
           KVEC = KVEC .* (35 / 32) ;      /*  CONSTANT FROM MARRON-NOLAN  */
         ELSE ;               /*  USE MARRON-NOLAN GENERAL FORMULA  */
           KVEC = KVEC^KPAR ;
           KVEC = KVEC .* (GAMMA(2*KPAR+2) * GAMMA(KPAR+1)^(-2)) ;
           KVEC = KVEC .* 2^(-2*KPAR-1) ;
         ENDIF ;
       ENDIF ;

       S0[IS:IE,1] = S0[IS:IE,1] + KVEC ;
       S1[IS:IE,1] = S1[IS:IE,1] + KVEC .* (ARG .* H) ;
       S2[IS:IE,1] = S2[IS:IE,1] + KVEC .* (ARG .* H) .* (ARG .* H) ;
       SY0[IS:IE,1] = SY0[IS:IE,1] + KVEC .* DATA[IOBS,2] ;
       SY1[IS:IE,1] = SY1[IS:IE,1] + KVEC .* (ARG .* H) .* DATA[IOBS,2] ;
     ENDIF ;
   ENDIF ;

   IOBS = IOBS + 1 ;
 ENDO ; ? ;

 DENOM = (S2 .* S0 - S1 .* S1) ;

 IF SUMC(DENOM .== 0) ;   /*  ANY ZERO ENTRY IN DENOMINATOR  */
   "*****************************************************************" ;
   "***                                                           ***" ;
   "***    WARNING: h is too small for smoothing this data set    ***" ;
   "***                                                           ***" ;
   "*****************************************************************" ;
   RETP(0) ;
 ENDIF ;

 RETP((S2 .* SY0 - S1 .* SY1) ./ DENOM) ;
ENDP ;
/* ============================ END PROC GPLLR1 ======================== */
