/* =========================== START PROC GPLLR2 ======================== */
PROC GPLLR2(XGRID,DATA,H,KPAR) ;
   /*  GASSER'S DIRECT CALCULATION OF A LOCAL LINEAR REGRESSION EST.  */
   /*  XGRID IS THE VECTOR OF SITES TO EVALUATE THE ESTIMATE     */
   /*          ASSUMED SORTED                            */
   /*  DATA IS MATRIX WHERE THE FIRST COLUMN ARE THE X'S  */
   /*      AND THE SECOND COLUMN ARE THE Y'S  */
   /*      ASSUMED SORTED ON THE X'S                      */
   /*  H IS THE BANDWIDTH, MUST BE A SCALAR    */
   /*  KERNEL SHAPE IS THE BETA,   SUPPORTED [-1,1],    WITH  */
   /*            KPAR = 0  -  UNIFORM   */
   /*            KPAR = 1  -  EPANECHNIKOV   */
   /*            KPAR = 2  -  BIWEIGHT   */
   /*            KPAR = 3  -  TRIWEIGHT   */
   /*  OUTPUT IS A THE VECTOR OF THE KERNEL REGRESSION ESTIMATE       */

 LOCAL NOBS,NXGRID,Y,VIS,VIE,DOH,XOH,XOH2,ARG,ARGN,
    RS0,RT0,RS1,RT1,RS2,RT2,RS3,RT3,RS4,RT4,RS5,RT5,RS6,RT6,RS7,RT7,RS8,RT8,
        S0,T0,S1,T1,S2,DENOM  ;

 NOBS = ROWS(DATA) ;                 /*  NUMBER OF DATA POINTS  */
 NXGRID = ROWS(XGRID) ;               /*  NUMBER OF GRIDPOINTS  */

 Y = DATA[.,2] ;

     /*  CONSTRUCT VECTOR OF STARTING INDICES  */
 VIE = COUNTS(DATA[.,1],XGRID + H) ;
 VIE = CUMSUMC(VIE) ;
     /*  CONSTRUCT VECTOR OF ENDING INDICES  */
 VIS = COUNTS(-DATA[.,1],REV(H - XGRID)) ;
 VIS = VIS[2:NXGRID]|(NOBS-SUMC(VIS)) ;
 VIS = REV(VIS) ;
 VIS = CUMSUMC(VIS) ;

     /*  ADD 0 TO BEGINNING TO HANDLE 0 INDICES  */
 VIS = VIS + 1 ;
 VIE = VIE + 1 ;

 RS0 = SEQA(1,1,NOBS) ;
 RS0 = 0|RS0 ;
 RS0 = RS0[VIE] - RS0[VIS] ;
 RT0 = CUMSUMC(Y) ;
 RT0 = 0|RT0 ;
 RT0 = RT0[VIE] - RT0[VIS] ;
 DOH = DATA[.,1] ./ H ;
 XOH = XGRID ./ H ;
 XOH2 = XOH .* XOH ;
   ARG = DOH ;
 RS1 = CUMSUMC(ARG) ;
 RS1 = 0|RS1 ;
 RS1 = RS1[VIE] - RS1[VIS] ;
   ARGN = ARG .* Y ;
 RT1 = CUMSUMC(ARGN) ;
 RT1 = 0|RT1 ;
 RT1 = RT1[VIE] - RT1[VIS] ;
   ARG = ARG .* DOH ;
 RS2 = CUMSUMC(ARG) ;
 RS2 = 0|RS2 ;
 RS2 = RS2[VIE] - RS2[VIS] ;
   ARGN = ARG.* Y ;
 RT2 = CUMSUMC(ARGN) ;
 RT2 = 0|RT2 ;
 RT2 = RT2[VIE] - RT2[VIS] ;
 IF KPAR >= 1 ;
     ARG = ARG .* DOH ;
   RS3 = CUMSUMC(ARG) ;
   RS3 = 0|RS3 ;
   RS3= RS3[VIE] - RS3[VIS] ;
     ARGN = ARG.* Y ;
   RT3 = CUMSUMC(ARGN) ;
   RT3 = 0|RT3 ;
   RT3 = RT3[VIE] - RT3[VIS] ;
     ARG = ARG .* DOH ;
   RS4 = CUMSUMC(ARG) ;
   RS4 = 0|RS4 ;
   RS4 = RS4[VIE] - RS4[VIS] ;
     ARGN = ARG.* Y ;
   RT4 = CUMSUMC(ARGN) ;
   RT4 = 0|RT4 ;
   RT4 = RT4[VIE] - RT4[VIS] ;
   IF KPAR >= 2 ;
       ARG = ARG .* DOH ;
     RS5 = CUMSUMC(ARG) ;
     RS5 = 0|RS5 ;
     RS5 = RS5[VIE] - RS5[VIS] ;
       ARGN = ARG.* Y ;
     RT5 = CUMSUMC(ARGN) ;
     RT5 = 0|RT5 ;
     RT5 = RT5[VIE] - RT5[VIS] ;
       ARG = ARG .* DOH ;
     RS6 = CUMSUMC(ARG) ;
     RS6 = 0|RS6 ;
     RS6 = RS6[VIE] - RS6[VIS] ;
       ARGN = ARG.* Y ;
     RT6 = CUMSUMC(ARGN) ;
     RT6 = 0|RT6 ;
     RT6 = RT6[VIE] - RT6[VIS] ;
     IF KPAR >= 3 ;
         ARG = ARG .* DOH ;
       RS7 = CUMSUMC(ARG) ;
       RS7 = 0|RS7 ;
       RS7 = RS7[VIE] - RS7[VIS] ;
         ARGN = ARG.* Y ;
       RT7 = CUMSUMC(ARGN) ;
       RT7 = 0|RT7 ;
       RT7 = RT7[VIE] - RT7[VIS] ;
         ARG = ARG .* DOH ;
       RS8 = CUMSUMC(ARG) ;
       RS8 = 0|RS8 ;
       RS8 = RS8[VIE] - RS8[VIS] ;
         ARGN = ARG.* Y ;
       RT8 = CUMSUMC(ARGN) ;
       RT8 = 0|RT8 ;
       RT8 = RT8[VIE] - RT8[VIS] ;
                    /*   DO TRIWEIGHT KERNEL  */
       S0 = (1 - XOH2)^3 .* RS0  + 6 * XOH .* (1 - XOH2)^2 .* RS1 ;
       S0 = S0 - 3 * (1 - 5 * XOH2) .* (1 - XOH2) .* RS2 ;
       S0 = S0 - 4 * XOH .* (3 - 5 * XOH2) .* RS3 + 3 * (1 - 5 * XOH2) .* RS4 ;
       S0 = S0 + 6 * XOH .* RS5 - RS6 ;
       T0 = (1 - XOH2)^3 .* RT0 + 6 * XOH .* (1 - XOH2)^2 .* RT1 ;
       T0 = T0 - 3 * (1 - 5 * XOH2) .* (1 - XOH2) .* RT2 ;
       T0 = T0 - 4 * XOH .* (3 - 5 * XOH2) .* RT3 + 3 * (1 - 5 * XOH2) .* RT4 ;
       T0 = T0 + 6 * XOH .* RT5 - RT6 ;
       S1 = XOH .* (1 - XOH2)^3 .* RS0 - (1 - XOH2)^2 .* (1 - 7 * XOH2) .* RS1 ;
       S1 = S1 - 3 * XOH .* (1 - XOH2) .* (3 - 7 * XOH2) .* RS2 ;
       S1 = S1 + (3 - 30 * XOH2 + 35 * XOH2 .* XOH2) .* RS3 ;
       S1 = S1 + 5 * XOH .* (3 - 7 * XOH2) .* RS4 - 3 * (1 - 7 * XOH2) .* RS5 ;
       S1 = H * (S1 - 7 * XOH .* RS6 + RS7) ;
       T1 = XOH .* (1 - XOH2)^3 .* RT0 - (1 - XOH2)^2 .* (1 - 7 * XOH2) .* RT1 ;
       T1 = T1 - 3 * XOH .* (1 - XOH2) .* (3 - 7 * XOH2) .* RT2 ;
       T1 = T1 + (3 - 30 * XOH2 + 35 * XOH2 .* XOH2) .* RT3 ;
       T1 = T1 + 5 * XOH .* (3 - 7 * XOH2) .* RT4 - 3 * (1 - 7 * XOH2) .* RT5 ;
       T1 = H * (T1 - 7 * XOH .* RT6 + RT7) ;
       S2 = XOH2 .* (1 - XOH2)^3 .* RS0 ;
       S2 = S2 - 2 * XOH .* (1 - XOH2)^2 .* (1 - 4 * XOH2) .* RS1 ;
       S2 = S2 + (1 - XOH2) .* (1 - 17 * XOH2 + 28 * XOH2 .* XOH2) .* RS2 ;
       S2 = S2 + 4 * XOH .* (3 - 15 * XOH2 + 14 * XOH2 .* XOH2) .* RS3 ;
       S2 = S2 - (3 - 45 * XOH2 + 70 * XOH2 .* XOH2) .* RS4 ;
       S2 = S2 - XOH .* (18 - 56 * XOH2) .* RS5 + (3 - 28 * XOH2) .* RS6 ;
       S2 = H * H * (S2 + 8 * XOH .* RS7 - RS8) ;
     ELSE ;         /*   DO BIWEIGHT KERNEL  */
       S0 = (1 - XOH2)^2 .* RS0 + 4 * XOH .* (1 - XOH2) .* RS1 ;
       S0 = S0 - 2 * (1 - 3 * XOH2) .* RS2 - 4 * XOH .* RS3 + RS4 ;
       T0 = (1 - XOH2)^2 .* RT0 + 4 * XOH .* (1 - XOH2) .* RT1 ;
       T0 = T0 - 2 * (1 - 3 * XOH2) .* RT2 - 4 * XOH .* RT3 + RT4 ;
       S1 = XOH .* (1 - XOH2)^2 .* RS0 - (1 - XOH2) .* (1 - 5 * XOH2) .* RS1 ;
       S1 = S1 - XOH .* (6 - 10 * XOH2) .* RS2 + 2 * (1 - 5 * XOH2) .* RS3 ;
       S1 = H * (S1 + 5 * XOH .* RS4 - RS5) ;
       T1 = XOH .* (1 - XOH2)^2 .* RT0 - (1 - XOH2) .* (1 - 5 * XOH2) .* RT1 ;
       T1 = T1 - XOH .* (6 - 10 * XOH2) .* RT2 + 2 * (1 - 5 * XOH2) .* RT3 ;
       T1 = H * (T1 + 5 * XOH .* RT4 - RT5) ;
       S2 = (1 - XOH2)^2 .* XOH2 .* RS0 ;
       S2 = S2 - 2 * XOH .* (1 - XOH2) .* (1 - 3 * XOH2) .* RS1 ;
       S2 = S2 + (1 - 12 * XOH2 + 15 * XOH2 .* XOH2) .* RS2 ;
       S2 = S2 + 4 * XOH .* (2 - 5 * XOH2) .* RS3 - (2 - 15 * XOH2) .* RS4 ;
       S2 = H * H * (S2 - 6 * XOH .* RS5 + RS6) ;
     ENDIF ;
   ELSE ;          /*    DO EPANECHINKOV KERNEL   */
     S0 = (1 - XOH2) .* RS0 + 2 * XOH .* RS1 - RS2 ;
     T0 = (1 - XOH2) .* RT0 + 2 * XOH .* RT1 - RT2 ;
     S1 = XOH .* (1 - XOH2) .* RS0 - (1 - 3 * XOH2) .* RS1 ;
     S1 = H * (S1 - 3 * XOH .* RS2 + RS3) ;
     T1 = XOH .* (1 - XOH2) .* RT0 - (1 - 3 * XOH2) .* RT1 ;
     T1 = H * (T1 - 3 * XOH .* RT2 + RT3) ;
     S2 = XOH2 .* (1 - XOH2) .* RS0 - XOH .* (2 - 4 * XOH2) .* RS1 ;
     S2 = H * H * (S2 + (1 - 6 * XOH2) .* RS2 + 4 * XOH .* RS3 - RS4) ;
   ENDIF ;
 ELSE ;            /*    DO UNIFORM KERNEL   */
   S0 = RS0 ;
   T0 = RT0 ;
   S1 = H * (XOH .* RS0 - RS1) ;
   T1 = H * (XOH .* RT0 - RT1) ;
   S2 = (H * H) * (XOH2 .* RS0 - 2 * XOH .* RS1 + RS2) ;
 ENDIF ;

 DENOM = (S2 .* S0 - S1 .* S1) ;

 IF SUMC(DENOM .== 0) ;   /*  ANY ZERO ENTRY IN DENOMINATOR  */
   "*****************************************************************" ;
   "***                                                           ***" ;
   "***    WARNING: h is too small for smoothing this data set    ***" ;
   "***                                                           ***" ;
   "*****************************************************************" ;
   RETP(0) ;
 ENDIF ;


 RETP((S2 .* T0 - S1 .* T1) ./ DENOM) ;
ENDP ;
/* ============================ END PROC GPLLR2 ======================== */
