/* =========================== START PROC GPNWR2 ======================== */
PROC GPNWR2(XGRID,DATA,H,KPAR) ;
   /*  GASSER'S DIRECT CALCULATION OF A NADARAYA WATSON REGRESSION EST.  */
   /*  XGRID IS THE VECTOR OF SITES TO EVALUATE THE ESTIMATE     */
   /*          ASSUMED SORTED                            */
   /*  DATA IS MATRIX WHERE THE FIRST COLUMN ARE THE X'S  */
   /*      AND THE SECOND COLUMN ARE THE Y'S  */
   /*      ASSUMED SORTED ON THE X'S                      */
   /*  H IS THE BANDWIDTH, MUST BE A SCALAR    */
   /*  KERNEL SHAPE IS THE BETA,   SUPPORTED [-1,1],    WITH  */
   /*            KPAR = 0  -  UNIFORM   */
   /*            KPAR = 1  -  EPANECHNIKOV   */
   /*            KPAR = 2  -  BIWEIGHT   */
   /*            KPAR = 3  -  TRIWEIGHT   */
   /*  OUTPUT IS A THE VECTOR OF THE KERNEL REGRESSION ESTIMATE       */

 LOCAL NOBS,NXGRID,DOH,XOH,XOH2,Y,VIS,VIE,ARG,ARGN,
        S0,S0N,S1,S1N,S2,S2N,S3,S3N,S4,S4N,S5,S5N,S6,S6N,DENO,NUME ;


 NOBS = ROWS(DATA) ;                 /*  NUMBER OF DATA POINTS  */
 NXGRID = ROWS(XGRID) ;               /*  NUMBER OF GRIDPOINTS  */

 Y = DATA[.,2] ;

     /*  CONSTRUCT VECTOR OF STARTING INDICES  */
 VIE = COUNTS(DATA[.,1],XGRID + H) ;
 VIE = CUMSUMC(VIE) ;
     /*  CONSTRUCT VECTOR OF ENDING INDICES  */
 VIS = COUNTS(-DATA[.,1],REV(H - XGRID)) ;
 VIS = VIS[2:NXGRID]|(NOBS-SUMC(VIS)) ;
 VIS = REV(VIS) ;
 VIS = CUMSUMC(VIS) ;

     /*  ADD 0 TO BEGINNING TO HANDLE 0 INDICES  */
 VIS = VIS + 1 ;
 VIE = VIE + 1 ;

 S0 = SEQA(1,1,NOBS) ;
 S0N = CUMSUMC(Y) ;
 S0 = 0|S0 ;
 S0N = 0|S0N ;
 S0 = S0[VIE] - S0[VIS] ;
 S0N = S0N[VIE] - S0N[VIS] ;
 IF KPAR >= 1 ;
   DOH = DATA[.,1] ./ H ;
   XOH = XGRID ./ H ;
   XOH2 = XOH .* XOH ;
   ARG = DOH ;
   S1 = CUMSUMC(ARG) ;
   ARGN = ARG .* Y ;
   S1N = CUMSUMC(ARGN) ;
   S1 = 0|S1 ;
   S1N = 0|S1N ;
   S1 = S1[VIE] - S1[VIS] ;
   S1N = S1N[VIE] - S1N[VIS] ;
   ARG = ARG .* DOH ;
   S2 = CUMSUMC(ARG) ;
   ARGN = ARG.* Y ;
   S2N = CUMSUMC(ARGN) ;
   S2 = 0|S2 ;
   S2N = 0|S2N ;
   S2 = S2[VIE] - S2[VIS] ;
   S2N = S2N[VIE] - S2N[VIS] ;
   IF KPAR >= 2 ;
     ARG = ARG .* DOH ;
     S3 = CUMSUMC(ARG) ;
     ARGN = ARG.* Y ;
     S3N = CUMSUMC(ARGN) ;
     S3 = 0|S3 ;
     S3N = 0|S3N ;
     S3= S3[VIE] - S3[VIS] ;
     S3N = S3N[VIE] - S3N[VIS] ;
     ARG = ARG .* DOH ;
     S4 = CUMSUMC(ARG) ;
     ARGN = ARG.* Y ;
     S4N = CUMSUMC(ARGN) ;
     S4 = 0|S4 ;
     S4N = 0|S4N ;
     S4 = S4[VIE] - S4[VIS] ;
     S4N = S4N[VIE] - S4N[VIS] ;
     IF KPAR >= 3 ;
       ARG = ARG .* DOH ;
       S5 = CUMSUMC(ARG) ;
       ARGN = ARG.* Y ;
       S5N = CUMSUMC(ARGN) ;
       S5 = 0|S5 ;
       S5N = 0|S5N ;
       S5 = S5[VIE] - S5[VIS] ;
       S5N = S5N[VIE] - S5N[VIS] ;
       ARG = ARG .* DOH ;
       S6 = CUMSUMC(ARG) ;
       ARGN = ARG.* Y ;
       S6N = CUMSUMC(ARGN) ;
       S6 = 0|S6 ;
       S6N = 0|S6N ;
       S6 = S6[VIE] - S6[VIS] ;
       S6N = S6N[VIE] - S6N[VIS] ;
                    /*   DO TRIWEIGHT KERNEL  */
       DENO = (1 - XOH2)^3 .* S0 ;
       NUME = (1 - XOH2)^3 .* S0N ;
       DENO = DENO + 6 * XOH .* (1 - XOH2)^2 .* S1 ;
       NUME = NUME + 6 * XOH .* (1 - XOH2)^2 .* S1N ;
       DENO = DENO - 3 * (1 - 5 * XOH2) .* (1 - XOH2) .* S2 ;
       NUME = NUME - 3 * (1 - 5 * XOH2) .* (1 - XOH2) .* S2N ;
       DENO = DENO - 4 * XOH .* (3 - 5 * XOH2) .* S3 ;
       NUME = NUME - 4 * XOH .* (3 - 5 * XOH2) .* S3N ;
       DENO = DENO + 3 * (1 - 5 * XOH2) .* S4 ;
       NUME = NUME + 3 * (1 - 5 * XOH2) .* S4N ;
       DENO = DENO + 6 * XOH .* S5 ;
       NUME = NUME + 6 * XOH .* S5N ;
       DENO = DENO - S6 ;
       NUME = NUME - S6N ;
     ELSE ;         /*   DO BIWEIGHT KERNEL  */
       DENO = (1 - XOH2)^2 .* S0 ;
       NUME = (1 - XOH2)^2 .* S0N ;
       DENO = DENO + 4 * XOH .* (1 - XOH2) .* S1 ;
       NUME = NUME + 4 * XOH .* (1 - XOH2) .* S1N ;
       DENO = DENO - 2 * (1 - 3 * XOH2) .* S2 ;
       NUME = NUME - 2 * (1 - 3 * XOH2) .* S2N ;
       DENO = DENO - 4 * XOH .* S3 ;
       NUME = NUME - 4 * XOH .* S3N ;
       DENO = DENO + S4 ;
       NUME = NUME + S4N ;
     ENDIF ;
   ELSE ;          /*    DO EPANECHINKOV KERNEL   */
     DENO = (1 - XOH2) .* S0 ;
     NUME = (1 - XOH2) .* S0N ;
     DENO = DENO + 2 * XOH .* S1 ;
     NUME = NUME + 2 * XOH .* S1N ;
     DENO = DENO - S2 ;
     NUME = NUME - S2N ;
   ENDIF ;
 ELSE ;            /*    DO UNIFORM KERNEL   */
   DENO = S0 ;
   NUME = S0N ;
 ENDIF ;

 IF SUMC(DENO .== 0) ;   /*  ANY ZERO ENTRY IN DENOMINATOR  */
   "*****************************************************************" ;
   "***                                                           ***" ;
   "***    WARNING: h is too small for smoothing this data set    ***" ;
   "***                                                           ***" ;
   "*****************************************************************" ;
   RETP(0) ;
 ENDIF ;

 RETP(NUME ./ DENO) ;
ENDP ;
/* ============================ END PROC GPNWR2 ======================== */
