/* =========================== START PROC GPSS1 ======================== */
PROC GPSS1(Y,VLAM) ;
    /*  SMOOTHING SPLINE FOR BINNED STUDY   */
    /*  FROM EUBANK'S NOTES  */
    /*  BANDED O(n) VERSION BASED ON SOL 5 BAND  */
    /*  ASSUMES X'S ARE EQUALLY SPACED ON [0,1]  */
    /*  Y IS THE VECTOR OF DATA    */
    /*  VLAM IS A VECTOR OF SMOOTHING PARAMETERS  */
    /*  RETURN IS A MATRIX OF SPLINES, WITH EACH COL FROM A LAMBDA  */

  LOCAL N,NL,UY,UUD,UUU1,UUU2,UUL1,UUL2,UY,MD,MU1,MU2,ML1,ML2,
           AD,AU1,AU2,AL1,AL2,IL,MUHAT,LAM,Z,R ;

  N = ROWS(Y) ;
  NL = ROWS(VLAM) ;

  UY = Y[3:N] - 2 * Y[2:(N-1)] + Y[1:(N-2)] ;
  UY = UY * N ;

  UUD = (6 * N * N) * ONES(N-2,1) ;
  UUU1 = (-4 * N * N) * ONES(N-3,1) ;
  UUU2 = (N * N) * ONES(N-4,1) ;
  UUL1 = UUU1 ;                     /*  UU SYMMETRIC THIS TIME  */
  UUL2 = UUU2 ;                     /*  UU SYMMETRIC THIS TIME  */

  MD = (4 / (6 * N)) * ONES(N-2,1) ;
  MU1 = (1 / (6 * N)) * ONES(N-3,1) ;
  ML1 = MU1 ;                     /*  M SYMMETRIC THIS TIME  */

  MUHAT = ZEROS(N,NL) ;
  IL = 1 ;
  DO WHILE IL <= NL ;
    LAM = VLAM[IL] ;

      AD = MD + N * LAM * UUD ;
      AU1 = MU1 + N * LAM * UUU1 ;
      AU2 = N * LAM * UUU2 ;      /*  M ONLY 3 BANDED  */
      AL1 = ML1 + N * LAM * UUL1 ;
      AL2 = N * LAM * UUL2 ;      /*  M ONLY 3 BANDED  */
    Z = SOL5BAND(AD,AU1,AU2,AL1,AL2,UY) ;

    Z = 0|0|Z|0|0 ;
    R = Z[1:N] - 2 * Z[2:N+1] + Z[3:N+2] ;
                       /*  THIS, IS U*Z/N, USING EQUAL SPACING  */
    R = N * N * LAM * R ;      /*  EXTRA FACTOR OF N, FROM ABOVE LINE  */
    MUHAT[.,IL] = Y - R ;

    IL = IL + 1 ;
  ENDO ;


  RETP(MUHAT) ;
ENDP ;
/* ============================ END PROC GPSS1 ======================== */
