/* =========================== START PROC GPSS1N ======================== */
PROC GPSS1N(Y,VLAM) ;
    /*  SMOOTHING SPLINE FOR BINNED STUDY   */
    /*  FROM EUBANK'S NOTES  */
    /*  "NAIVE" VERSION BASED ON MATRIX CALCULATIONS  */
    /*  ASSUMES X'S ARE EQUALLY SPACED ON [0,1]  */
    /*  Y IS THE VECTOR OF DATA    */
    /*  VLAM IS A VECTOR OF SMOOTHING PARAMETERS  */
    /*  RETURN IS A MATRIX OF SPLINES, WITH EACH COL FROM A LAMBDA  */

  LOCAL N,NL,U,UU,UY,M,IL,MUHAT,LAM,COEFF,Z,R ;

  N = ROWS(Y) ;
  NL = ROWS(VLAM) ;

  U = N|(-2*N)|N|ZEROS(N-2,1) ;
  U = RESHAPE(U,N-2,N) ;
  U = U' ;

  UU = U' * U ;

  UY = U' * Y ;

  M = (4/N)|(1/N)|ZEROS(N-4,1)|(1/N) ;
  M = RESHAPE(M,N-2,N-2) ;
  M = M / 6 ;

  MUHAT = ZEROS(N,NL) ;
  IL = 1 ;
  DO WHILE IL <= NL ;
    LAM = VLAM[IL] ;

    COEFF = M + N * LAM * UU ;
    Z = SOLPD(UY,COEFF) ;

    R = N * LAM * U * Z ;
    MUHAT[.,IL] = Y - R ;

    IL = IL + 1 ;
  ENDO ;


  RETP(MUHAT) ;
ENDP ;
/* ============================ END PROC GPSS1N ======================== */
