/* =========================== START PROC GPSS2 ======================== */
PROC GPSS2(DATA,VLAM) ;
    /*  SMOOTHING SPLINE FOR BINNED STUDY   */
    /*  FROM EUBANK'S NOTES  */
    /*  BANDED O(n) VERSION BASED ON SOL 5 BAND  */
    /*  DATA IS MATRIX WHERE THE FIRST COLUMN ARE THE X'S  */
    /*      AND THE SECOND COLUMN ARE THE Y'S  */
    /*  CAUTION:           ASSUMES X'S ARE sorted  */
    /*  VLAM IS A VECTOR OF SMOOTHING PARAMETERS  */
    /*  RETURN IS A MATRIX OF SPLINES, WITH EACH COL FROM A LAMBDA  */

  LOCAL N,NL,DEL,DELI,DELI2,PDELI,UY,UUD,UUU1,UUU2,UUL1,UUL2,UY,
        MD,MU1,MU2,ML1,ML2,AD,AU1,AU2,AL1,AL2,IL,MUHAT,LAM,Z,R ;

  N = ROWS(DATA) ;
  NL = ROWS(VLAM) ;

  DEL = DATA[2:N,1] - DATA[1:(N-1),1] ;
  DELI = 1 ./ DEL ;
  DELI2 = DELI .* DELI ;
  PDELI = DELI[1:(N-2)] .* DELI[2:(N-1)] ;

  UY = DATA[2:N,2] - DATA[1:(N-1),2] ;    /*  PAIRWISE DIFFERENCE OF Y'S  */
  UY = DELI .* UY ;
  UY = UY[2:(N-1)] - UY[1:(N-2)] ;

  UUD = DELI[1:(N-2)] + DELI[2:(N-1)] ;
  UUD = UUD .* UUD ;
  UUD = DELI2[1:(N-2)] + UUD + DELI2[2:(N-1)] ;
  UUU1 = -PDELI[1:(N-3)] - 2 * DELI2[2:(N-2)] - PDELI[2:(N-2)] ;
  UUU2 = PDELI[2:(N-3)] ;
  UUL1 = UUU1 ;                     /*  UU SYMMETRIC THIS TIME  */
  UUL2 = UUU2 ;                     /*  UU SYMMETRIC THIS TIME  */

  MD = (DEL[1:(N-2)] + DEL[2:(N-1)]) / 3 ;
  MU1 = DEL[2:(N-2)] / 6 ;
  ML1 = MU1 ;                     /*  M SYMMETRIC THIS TIME  */


  MUHAT = ZEROS(N,NL) ;
  IL = 1 ;
  DO WHILE IL <= NL ;
    LAM = VLAM[IL] ;

      AD = MD + N * LAM * UUD ;
      AU1 = MU1 + N * LAM * UUU1 ;
      AU2 = N * LAM * UUU2 ;      /*  M ONLY 3 BANDED  */
      AL1 = ML1 + N * LAM * UUL1 ;
      AL2 = N * LAM * UUL2 ;      /*  M ONLY 3 BANDED  */
    Z = SOL5BAND(AD,AU1,AU2,AL1,AL2,UY) ;

    Z = 0|0|Z|0|0 ;
    R = Z[1:(N+1)] - Z[2:(N+2)] ;
    R = R .* (0|DELI|0) ;
    R = R[1:N] - R[2:(N+1)] ;

    R = N * LAM * R ;
    MUHAT[.,IL] = DATA[.,2] - R ;

    IL = IL + 1 ;
  ENDO ;

  RETP(MUHAT) ;
ENDP ;
/* ============================ END PROC GPSS2 ======================== */
