/* =========================== START PROC GPSS2N ======================== */
PROC GPSS2N(DATA,VLAM) ;
    /*  SMOOTHING SPLINE FOR BINNED STUDY   */
    /*  FROM EUBANK'S NOTES  */
    /*  "NAIVE" VERSION BASED ON MATRIX CALCULATIONS  */
    /*  DATA IS MATRIX WHERE THE FIRST COLUMN ARE THE X'S  */
    /*      AND THE SECOND COLUMN ARE THE Y'S  */
    /*  CAUTION:           ASSUMES X'S ARE sorted  */
    /*  VLAM IS A VECTOR OF SMOOTHING PARAMETERS  */
    /*  RETURN IS A MATRIX OF SPLINES, WITH EACH COL FROM A LAMBDA  */

  LOCAL N,NL,DEL,DELI,U,UU,UY,M,IL,MUHAT,LAM,COEFF,Z,R ;

  N = ROWS(DATA) ;
  NL = ROWS(VLAM) ;

  DEL = DATA[2:N,1] - DATA[1:(N-1),1] ;
  DELI = 1 ./ DEL ;

  U = ZEROS(N,N-2) ;
  U[1:(N-2),.] = DIAGRV(U[1:(N-2),.],DELI[1:(N-2)]) ;
  U[2:(N-1),.] = DIAGRV(U[2:(N-1),.],-DELI[1:(N-2)]-DELI[2:(N-1)]) ;
  U[3:N,.] = DIAGRV(U[3:N,.],DELI[2:(N-1)]) ;

  UU = U' * U ;

  UY = U' * DATA[.,2] ;

  M = ZEROS(N-2,N-2) ;
  M[.,2:(N-2)] = DIAGRV(M[.,2:(N-2)],DEL[2:(N-2)] / 6) ;
  M = DIAGRV(M,(DEL[1:(N-2)]+DEL[2:(N-1)]) / 3) ;
  M[2:(N-2),.] = DIAGRV(M[2:(N-2),.],DEL[2:(N-2)] / 6) ;


  MUHAT = ZEROS(N,NL) ;
  IL = 1 ;
  DO WHILE IL <= NL ;
    LAM = VLAM[IL] ;

    COEFF = M + N * LAM * UU ;
    Z = SOLPD(UY,COEFF) ;

    R = N * LAM * U * Z ;
    MUHAT[.,IL] = DATA[.,2] - R ;

    IL = IL + 1 ;
  ENDO ;


  RETP(MUHAT) ;
ENDP ;
/* ============================ END PROC GPSS2N ======================== */
