/* =========================== START PROC GPSS3N ======================== */
PROC GPSS3N(DATA,VLAM) ;
    /*  SMOOTHING SPLINE FOR BINNED STUDY   */
    /*  WEIGHTED VERSION, FROM EUBANK'S NOTES  */
    /*  "NAIVE" VERSION BASED ON MATRIX CALCULATIONS  */
    /*  DATA IS MATRIX WHERE THE FIRST COLUMN ARE THE X'S  */
    /*          SECOND COLUMN ARE THE BIN COUNTS   */
    /*      AND THIRD COLUMN ARE THE Y'S  */
    /*  CAUTION:           no 0 BIN COUNTS ALLOWED  */
    /*  CAUTION:           ASSUMES X'S ARE sorted  */
    /*  VLAM IS A VECTOR OF SMOOTHING PARAMETERS  */
    /*  RETURN IS A MATRIX OF SPLINES, WITH EACH COL FROM A LAMBDA  */

  LOCAL N,NL,DEL,DELI,WI,U,UU,UY,M,IL,MUHAT,LAM,COEFF,Z,R ;

  N = ROWS(DATA) ;
  NL = ROWS(VLAM) ;

  DEL = DATA[2:N,1] - DATA[1:(N-1),1] ;
  DELI = 1 ./ DEL ;

  WI = ZEROS(N,N) ;
  WI = DIAGRV(WI,1./DATA[.,2]) ;

  U = ZEROS(N,N-2) ;
  U[1:(N-2),.] = DIAGRV(U[1:(N-2),.],DELI[1:(N-2)]) ;
  U[2:(N-1),.] = DIAGRV(U[2:(N-1),.],-DELI[1:(N-2)]-DELI[2:(N-1)]) ;
  U[3:N,.] = DIAGRV(U[3:N,.],DELI[2:(N-1)]) ;

  UU = U' * WI * U ;

  UY = U' * DATA[.,3] ;

  M = ZEROS(N-2,N-2) ;
  M[.,2:(N-2)] = DIAGRV(M[.,2:(N-2)],DEL[2:(N-2)] / 6) ;
  M = DIAGRV(M,(DEL[1:(N-2)]+DEL[2:(N-1)]) / 3) ;
  M[2:(N-2),.] = DIAGRV(M[2:(N-2),.],DEL[2:(N-2)] / 6) ;


  MUHAT = ZEROS(N,NL) ;
  IL = 1 ;
  DO WHILE IL <= NL ;
    LAM = VLAM[IL] ;

    COEFF = M + N * LAM * UU ;
    Z = SOLPD(UY,COEFF) ;

    R = N * LAM * WI * U * Z ;
    MUHAT[.,IL] = DATA[.,3] - R ;

    IL = IL + 1 ;
  ENDO ;


  RETP(MUHAT) ;
ENDP ;
/* ============================ END PROC GPSS3N ======================== */
