/* =========================== START PROC GPSS4 ======================== */
PROC GPSS4(RBINDAT,LEFT,RIGHT,VLAM) ;
    /*  SMOOTHING SPLINE FOR BINNED STUDY   */
    /*  WEIGHTED VERSION, FROM EUBANK'S NOTES  */
    /*  BANDED O(n) VERSION BASED ON SOL 5 BAND  */
    /*  RBINDAT IS OUTPUT FROM REGRESSION BINNING PROC  BNLBR1  */
    /*         I. E. 1ST COLUMN IS COUNTS, 2ND IS BIN TOTALS OF Y'S  */
    /*  LEFT AND RIGHT ARE GRID ENDPOINTS, AS USED THERE  */
    /*  VLAM IS A VECTOR OF SMOOTHING PARAMETERS  */
    /*  RETURN IS A MATRIX OF SPLINES, WITH EACH COL FROM A LAMBDA  */
    /*  EVALUATED ON THE BINNING GRID  */

LOCAL NXGRID,NOBS,NL,INCX,NZFLAG,NZIND,NZN,NZDATA,ZFLAG,ZN,ZIND,ZNL,ZINDL,
    ZNC,ZINDC,ZNR,ZINDR,DEL,DELI,DELI2,PDELI,SDELI,CTI,UY,UUD,UUU1,UUU2,
    UUL1,UUL2,MD,MU1,ML1,MUHAT,IL,LAM,AD,AU1,AU2,AL1,AL2,Z,R,D,ZIM1OLD,
    ZIOLD,DELOLD,F0,F1,F1P,F2P,F3P,IZC,I,IOLD,IRED,IOLDP1,F2,F3 ;


  NXGRID = ROWS(RBINDAT) ;
  NOBS = SUMC(RBINDAT) ;
  NL = ROWS(VLAM) ;
  INCX = (RIGHT - LEFT) / (NXGRID - 1) ;

  NZFLAG = (RBINDAT[.,1] .> 10^(-10))  ;      /*  FLAG NONZERO BINS  */
  NZIND = SELIF(SEQA(1,1,NXGRID),NZFLAG) ;    /*  INDICES OF NONZEROERS  */
  NZN = ROWS(NZIND) ;                         /*  NUMBER OF NONZERO BINS  */
  NZDATA = SEQA(LEFT,INCX,NXGRID)~RBINDAT ;
  NZDATA = NZDATA[NZIND,.] ;                  /*  NONZERO VERSION OF DATA  */
  NZDATA[.,3] = NZDATA[.,3] ./ NZDATA[.,2] ;  /*  COUNTS TO AVERAGES  */

  ZFLAG = 1 - NZFLAG ;                        /*  FLAG ZERO BINS  */
  ZN = SUMC(ZFLAG) ;                           /*  NUMBER OF ZEROES BINS */
  IF ZN > 0 ;
    ZIND = SELIF(SEQA(1,1,NXGRID),ZFLAG) ;    /*  INDICES OF ZEROERS  */
  ELSE ;
    ZIND = 0 ;
  ENDIF ;

  IF ZN == NXGRID ;
    "****************************************" ;
    "***   NO DATA HERE, CAN'T SMOOTH!   ***" ;
    "****************************************" ;
    RETP(0) ;
  ENDIF ;


  IF ZFLAG[1] == 1 ;         /*  SOME ZEROS AT LEFT END  */
    ZNL = MAXINDC(NZFLAG) - 1 ;        /*  NUMBER OF ZERO BINS AT LEFT  */
    ZINDL = ZIND[1:ZNL] ;              /*  INDICES ON LEFT    */
    IF ZNL < ZN ;                /*  STILL HAVE ZEROS LEFTOVER  */
      ZNC = ZN - ZNL ;                   /*  NUMBER OF INDICES LEFTOVER  */
      ZINDC = ZIND[(ZNL+1):ZN] ;         /*  INDICES LEFT OVER  */
    ELSE ;                       /*  NOTHING LEFT OVER  */
      ZNC = 0 ;                          /*  FLAG NO CENTER ZEROS  */
      ZNR = 0 ;                          /*  FLAG NO RIGHT ZEROS  */
    ENDIF ;
  ELSE ;                     /*  NO ZEROS AT LEFT, SO UPDATE STUFF  */
    ZNL = 0 ;                          /*  FLAG NO LEFT ZEROS  */
    ZNC = ZN ;                         /*  START CENTER STUFF  */
    ZINDC = ZIND ;
  ENDIF ;

  IF ZFLAG[NXGRID] == 1 ;     /*  SOME ZEROS AT RIGHT END  */
    ZNR = MAXINDC(REV(NZFLAG)) - 1 ;
                                       /*  NUMBER OF ZERO BINS AT RIGHT  */
    ZINDR = ZINDC[(ZNC-ZNR+1):ZNC] ;   /*  INDICES ON RIGHT    */
    IF ZNR < ZNC ;                /*  STILL HAVE ZEROS LEFTOVER  */
      ZNC = ZNC - ZNR ;                  /*  NUMBER OF INDICES LEFTOVER  */
      ZINDC = ZINDC[1:ZNC] ;             /*  INDICES LEFT OVER  */
    ELSE ;                       /*  NOTHING LEFT OVER  */
      ZNC = 0 ;                          /*  FLAG NO CENTER ZEROS  */
    ENDIF ;
  ELSE ;                      /*  NO ZEROS AT RIGHT  */
    ZNR = 0 ;                          /*  FLAG NO RIGHT ZEROS  */
  ENDIF ;


  DEL = NZDATA[2:NZN,1] - NZDATA[1:(NZN-1),1] ;
  DELI = 1 ./ DEL ;
  DELI2 = DELI .* DELI ;
  PDELI = DELI[1:(NZN-2)] .* DELI[2:(NZN-1)] ;
  SDELI = DELI[1:(NZN-2)] + DELI[2:(NZN-1)] ;

  CTI = 1 ./ NZDATA[.,2] ;

  UY = NZDATA[2:NZN,3] - NZDATA[1:(NZN-1),3] ;
                        /*  PAIRWISE DIFFERENCE OF Y'S  */
  UY = DELI .* UY ;
  UY = UY[2:(NZN-1)] - UY[1:(NZN-2)] ;

  UUD = CTI[2:(NZN-1)] .* SDELI .* SDELI ;
  UUD = CTI[1:(NZN-2)] .* DELI2[1:(NZN-2)] + UUD ;
  UUD = UUD + CTI[3:NZN] .* DELI2[2:(NZN-1)] ;
  UUU1 = -CTI[2:(NZN-1)] .* SDELI[1:(NZN-2)] ;
  UUU1 = UUU1[1:(NZN-3)] + UUU1[2:(NZN-2)] ;
  UUU1 = UUU1 .* DELI[2:(NZN-2)] ;
  UUL1 = UUU1 ;                     /*  UU SYMMETRIC THIS TIME  */
  IF NZN > 4.5 ;
    UUU2 = CTI[3:(NZN-2)] .* PDELI[2:(NZN-3)] ;
    UUL2 = UUU2 ;                     /*  UU SYMMETRIC THIS TIME  */
  ELSE ;
    UUU2 = 0 ;
    UUL2 = 0 ;
  ENDIF ;

  MD = (DEL[1:(NZN-2)] + DEL[2:(NZN-1)]) / 3 ;
  MU1 = DEL[2:(NZN-2)] / 6 ;
  ML1 = MU1 ;                     /*  M SYMMETRIC THIS TIME  */


  MUHAT = ZEROS(NXGRID,NL) ;
  IL = 1 ;
  DO WHILE IL <= NL ;
    LAM = VLAM[IL] ;

      AD = MD + NZN * LAM * UUD ;
      AU1 = MU1 + NZN * LAM * UUU1 ;
      AU2 = NZN * LAM * UUU2 ;      /*  M ONLY 3 BANDED  */
      AL1 = ML1 + NZN * LAM * UUL1 ;
      AL2 = NZN * LAM * UUL2 ;      /*  M ONLY 3 BANDED  */
    Z = SOL5BAND(AD,AU1,AU2,AL1,AL2,UY) ;

    Z = 0|0|Z|0|0 ;
    R = Z[1:(NZN+1)] - Z[2:(NZN+2)] ;
    R = R .* (0|DELI|0) ;
    R = R[1:NZN] - R[2:(NZN+1)] ;
    R = CTI .* R ;

    R = NZN * LAM * R ;
    MUHAT[NZIND,IL] = NZDATA[.,3] - R ;   /*  USUAL SPLINE AT NONZERO BINS  */


    Z = Z[2:ROWS(Z)-1] ;         /*  PREPARE FOR INTERPOLATION  */

    IF ZNL > 0 ;        /*  NEED TO EXTRAPOLATE - LEFT END  */
      D = XGRID[ZINDL] - NZDATA[1,1] ;
      ZIM1OLD = Z[1] ;             /*  CAREFUL ABOUT SHIFTED INDICES HERE */
      ZIOLD = Z[2] ;
      DELOLD = DEL[1] ;
      F0 = MUHAT[NZIND[1],IL] ;
      F1 = (MUHAT[NZIND[2],IL] - MUHAT[NZIND[1],IL]) / DELOLD ;
      F1 = F1  -  (ZIM1OLD * DELOLD / 2) ;
      F1 = F1  -  ((ZIOLD - ZIM1OLD) * DELOLD / 6) ;
      MUHAT[ZINDL,IL] = F0  +  F1 * D ;
    ENDIF ;

    IF ZNR > 0 ;        /*  NEED TO EXTRAPOLATE - RIGHT END  */
      D = XGRID[ZINDR] - NZDATA[NZN,1] ;
      ZIM1OLD = Z[NZN-1] ;             /*  CAREFUL ABOUT SHIFTED INDICES HERE */
      ZIOLD = Z[NZN] ;
      DELOLD = DEL[NZN-1] ;
      F1P = (MUHAT[NZIND[NZN],IL] - MUHAT[NZIND[NZN-1],IL]) / DELOLD ;
      F1P = F1P  -  (ZIM1OLD * DELOLD / 2) ;
      F1P = F1P  -  ((ZIOLD - ZIM1OLD) * DELOLD / 6) ;
      F2P = ZIM1OLD ;
      F2P = F2P / 2 ;
      F3P = (ZIOLD - ZIM1OLD) / DELOLD ;
      F3P = F3P / 6 ;
      DELOLD = DEL[NZN-1] ;
      F0 = MUHAT[NZIND[NZN],IL] ;
      F1 =  F1P  +  F2P * DELOLD +  F3P * DELOLD * DELOLD / 2  ;
      MUHAT[ZINDR,IL] = F0  +  F1 * D ;
    ENDIF ;

    IZC = 1 ;
    DO WHILE IZC <= ZNC ;      /*  LOOP THROUGH ZERO BINS IN CENTER  */
      I = ZINDC[IZC] ;
      IOLD = SELIF(NZIND,((I - NZIND) .> 0)) ;    /*  NONZEROS INDS < I  */
      IRED = ROWS(IOLD) ;                         /*  REDUCED INDEX OF LAST */
      IOLD = IOLD[IRED] ;                         /*  LAST ONE  */
      IOLDP1 = SELIF(NZIND,((NZIND - I) .> 0)) ;     /*  NONZEROS INDS > I  */
      IOLDP1 = IOLDP1[1] ;                             /*  FIRST ONE  */
      D = XGRID[I] - NZDATA[IRED,1] ;
      ZIM1OLD = Z[IRED] ;           /*  CAREFUL ABOUT SHIFTED INDICES HERE */
      ZIOLD = Z[IRED+1] ;
      DELOLD = DEL[IRED] ;
      F0 = MUHAT[IOLD,IL] ;
      F1 = (MUHAT[IOLDP1,IL] - MUHAT[IOLD,IL]) / DELOLD ;
      F1 = F1  -  (ZIM1OLD * DELOLD / 2) ;
      F1 = F1  -  ((ZIOLD - ZIM1OLD) * DELOLD / 6) ;
      F2 = ZIM1OLD ;
      F2 = F2 / 2 ;
      F3 = (ZIOLD - ZIM1OLD) / DELOLD ;
      F3 = F3 / 6 ;
      MUHAT[I,IL] = F0  +  F1 * D  +  F2 * D*D  +  F3 * D*D*D ;
      IZC = IZC + 1 ;
    ENDO ;


    IL = IL + 1 ;
  ENDO ;

  RETP(MUHAT) ;
ENDP ;
/* ============================ END PROC GPSS4 ======================== */
