/* =========================== START PROC GPSS4N ======================== */
PROC GPSS4N(RBINDAT,LEFT,RIGHT,VLAM) ;
    /*  SMOOTHING SPLINE FOR BINNED STUDY   */
    /*  WEIGHTED VERSION, FROM EUBANK'S NOTES  */
    /*  "NAIVE" VERSION BASED ON MATRIX CALCULATIONS  */
    /*  RBINDAT IS OUTPUT FROM REGRESSION BINNING PROC  BNLBR1  */
    /*         I. E. 1ST COLUMN IS COUNTS, 2ND IS BIN TOTALS OF Y'S  */
    /*  LEFT AND RIGHT ARE GRID ENDPOINTS, AS USED THERE  */
    /*  VLAM IS A VECTOR OF SMOOTHING PARAMETERS  */
    /*  RETURN IS A MATRIX OF SPLINES, WITH EACH COL FROM A LAMBDA  */
    /*  EVALUATED ON THE BINNING GRID  */

  LOCAL NXGRID,NOBS,NL,INCX,NZFLAG,NZIND,NZN,NZDATA,ZFLAG,ZIND,ZN,
      ZNL,ZINDL,ZINDC,ZNC,ZNR,ZINDR,IZC,
      DEL,DELI,WI,U,UU,UY,M,IL,MUHAT,LAM,COEFF,Z,R,
      I,IOLD,IRED,IOLDP1,D,ZIM1OLD,ZIOLD,DELOLD,F0,F1,F2,F3,F1P,F2P,F3P ;

  NXGRID = ROWS(RBINDAT) ;
  NOBS = SUMC(RBINDAT) ;
  NL = ROWS(VLAM) ;
  INCX = (RIGHT - LEFT) / (NXGRID - 1) ;

  NZFLAG = (RBINDAT[.,1] .> 10^(-10))  ;      /*  FLAG NONZERO BINS  */
  NZIND = SELIF(SEQA(1,1,NXGRID),NZFLAG) ;    /*  INDICES OF NONZEROERS  */
  NZN = ROWS(NZIND) ;                         /*  NUMBER OF NONZERO BINS  */
  NZDATA = SEQA(LEFT,INCX,NXGRID)~RBINDAT ;
  NZDATA = NZDATA[NZIND,.] ;                  /*  NONZERO VERSION OF DATA  */
  NZDATA[.,3] = NZDATA[.,3] ./ NZDATA[.,2] ;  /*  COUNTS TO AVERAGES  */

  ZFLAG = 1 - NZFLAG ;                        /*  FLAG ZERO BINS  */
  ZN = SUMC(ZFLAG) ;                           /*  NUMBER OF ZEROES BINS */
  IF ZN > 0 ;
    ZIND = SELIF(SEQA(1,1,NXGRID),ZFLAG) ;    /*  INDICES OF ZEROERS  */
  ELSE ;
    ZIND = 0 ;
  ENDIF ;

  IF ZN == NXGRID ;
    "****************************************" ;
    "***   NO DATA HERE, CAN'T SMOOTH!   ***" ;
    "****************************************" ;
    RETP(0) ;
  ENDIF ;


  IF ZFLAG[1] == 1 ;         /*  SOME ZEROS AT LEFT END  */
    ZNL = MAXINDC(NZFLAG) - 1 ;        /*  NUMBER OF ZERO BINS AT LEFT  */
    ZINDL = ZIND[1:ZNL] ;              /*  INDICES ON LEFT    */
    IF ZNL < ZN ;                /*  STILL HAVE ZEROS LEFTOVER  */
      ZNC = ZN - ZNL ;                   /*  NUMBER OF INDICES LEFTOVER  */
      ZINDC = ZIND[(ZNL+1):ZN] ;         /*  INDICES LEFT OVER  */
    ELSE ;                       /*  NOTHING LEFT OVER  */
      ZNC = 0 ;                          /*  FLAG NO CENTER ZEROS  */
      ZNR = 0 ;                          /*  FLAG NO RIGHT ZEROS  */
    ENDIF ;
  ELSE ;                     /*  NO ZEROS AT LEFT, SO UPDATE STUFF  */
    ZNL = 0 ;                          /*  FLAG NO LEFT ZEROS  */
    ZNC = ZN ;                         /*  START CENTER STUFF  */
    ZINDC = ZIND ;
  ENDIF ;

  IF ZFLAG[NXGRID] == 1 ;     /*  SOME ZEROS AT RIGHT END  */
    ZNR = MAXINDC(REV(NZFLAG)) - 1 ;
                                       /*  NUMBER OF ZERO BINS AT RIGHT  */
    ZINDR = ZINDC[(ZNC-ZNR+1):ZNC] ;   /*  INDICES ON RIGHT    */
    IF ZNR < ZNC ;                /*  STILL HAVE ZEROS LEFTOVER  */
      ZNC = ZNC - ZNR ;                  /*  NUMBER OF INDICES LEFTOVER  */
      ZINDC = ZINDC[1:ZNC] ;             /*  INDICES LEFT OVER  */
    ELSE ;                       /*  NOTHING LEFT OVER  */
      ZNC = 0 ;                          /*  FLAG NO CENTER ZEROS  */
    ENDIF ;
  ELSE ;                      /*  NO ZEROS AT RIGHT  */
    ZNR = 0 ;                          /*  FLAG NO RIGHT ZEROS  */
  ENDIF ;


  DEL = NZDATA[2:NZN,1] - NZDATA[1:(NZN-1),1] ;
  DELI = 1 ./ DEL ;

  WI = ZEROS(NZN,NZN) ;
  WI = DIAGRV(WI,1./NZDATA[.,2]) ;

  U = ZEROS(NZN,NZN-2) ;
  U[1:(NZN-2),.] = DIAGRV(U[1:(NZN-2),.],DELI[1:(NZN-2)]) ;
  U[2:(NZN-1),.] = DIAGRV(U[2:(NZN-1),.],-DELI[1:(NZN-2)]-DELI[2:(NZN-1)]) ;
  U[3:NZN,.] = DIAGRV(U[3:NZN,.],DELI[2:(NZN-1)]) ;

  UU = U' * WI * U ;

  UY = U' * NZDATA[.,3] ;

  M = ZEROS(NZN-2,NZN-2) ;
  M[.,2:(NZN-2)] = DIAGRV(M[.,2:(NZN-2)],DEL[2:(NZN-2)] / 6) ;
  M = DIAGRV(M,(DEL[1:(NZN-2)]+DEL[2:(NZN-1)]) / 3) ;
  M[2:(NZN-2),.] = DIAGRV(M[2:(NZN-2),.],DEL[2:(NZN-2)] / 6) ;


  MUHAT = ZEROS(NXGRID,NL) ;
  IL = 1 ;
  DO WHILE IL <= NL ;
    LAM = VLAM[IL] ;

    COEFF = M + NZN * LAM * UU ;
    Z = SOLPD(UY,COEFF) ;

    R = NZN * LAM * WI * U * Z ;
    MUHAT[NZIND,IL] = NZDATA[.,3] - R ;    /*  USUAL SPLINE AT NONZERO BINS  */

    Z = 0|Z|0 ;                  /*  PREPARE FOR INTERPOLATION  */


    IF ZNL > 0 ;        /*  NEED TO EXTRAPOLATE - LEFT END  */
      D = XGRID[ZINDL] - NZDATA[1,1] ;
      ZIM1OLD = Z[1] ;             /*  CAREFUL ABOUT SHIFTED INDICES HERE */
      ZIOLD = Z[2] ;
      DELOLD = DEL[1] ;
      F0 = MUHAT[NZIND[1],IL] ;
      F1 = (MUHAT[NZIND[2],IL] - MUHAT[NZIND[1],IL]) / DELOLD ;
      F1 = F1  -  (ZIM1OLD * DELOLD / 2) ;
      F1 = F1  -  ((ZIOLD - ZIM1OLD) * DELOLD / 6) ;
      MUHAT[ZINDL,IL] = F0  +  F1 * D ;
    ENDIF ;

    IF ZNR > 0 ;        /*  NEED TO EXTRAPOLATE - RIGHT END  */
      D = XGRID[ZINDR] - NZDATA[NZN,1] ;
      ZIM1OLD = Z[NZN-1] ;             /*  CAREFUL ABOUT SHIFTED INDICES HERE */
      ZIOLD = Z[NZN] ;
      DELOLD = DEL[NZN-1] ;
      F1P = (MUHAT[NZIND[NZN],IL] - MUHAT[NZIND[NZN-1],IL]) / DELOLD ;
      F1P = F1P  -  (ZIM1OLD * DELOLD / 2) ;
      F1P = F1P  -  ((ZIOLD - ZIM1OLD) * DELOLD / 6) ;
      F2P = ZIM1OLD ;
      F2P = F2P / 2 ;
      F3P = (ZIOLD - ZIM1OLD) / DELOLD ;
      F3P = F3P / 6 ;
      DELOLD = DEL[NZN-1] ;
      F0 = MUHAT[NZIND[NZN],IL] ;
      F1 =  F1P  +  F2P * DELOLD +  F3P * DELOLD * DELOLD / 2  ;
      MUHAT[ZINDR,IL] = F0  +  F1 * D ;
    ENDIF ;

    IZC = 1 ;
    DO WHILE IZC <= ZNC ;      /*  LOOP THROUGH ZERO BINS IN CENTER  */
      I = ZINDC[IZC] ;
      IOLD = SELIF(NZIND,((I - NZIND) .> 0)) ;    /*  NONZEROS INDS < I  */
      IRED = ROWS(IOLD) ;                         /*  REDUCED INDEX OF LAST */
      IOLD = IOLD[IRED] ;                         /*  LAST ONE  */
      IOLDP1 = SELIF(NZIND,((NZIND - I) .> 0)) ;     /*  NONZEROS INDS > I  */
      IOLDP1 = IOLDP1[1] ;                             /*  FIRST ONE  */
      D = XGRID[I] - NZDATA[IRED,1] ;
      ZIM1OLD = Z[IRED] ;           /*  CAREFUL ABOUT SHIFTED INDICES HERE */
      ZIOLD = Z[IRED+1] ;
      DELOLD = DEL[IRED] ;
      F0 = MUHAT[IOLD,IL] ;
      F1 = (MUHAT[IOLDP1,IL] - MUHAT[IOLD,IL]) / DELOLD ;
      F1 = F1  -  (ZIM1OLD * DELOLD / 2) ;
      F1 = F1  -  ((ZIOLD - ZIM1OLD) * DELOLD / 6) ;
      F2 = ZIM1OLD ;
      F2 = F2 / 2 ;
      F3 = (ZIOLD - ZIM1OLD) / DELOLD ;
      F3 = F3 / 6 ;
      MUHAT[I,IL] = F0  +  F1 * D  +  F2 * D*D  +  F3 * D*D*D ;
      IZC = IZC + 1 ;
    ENDO ;

    IL = IL + 1 ;
  ENDO ;


  RETP(MUHAT) ;
ENDP ;
/* ============================ END PROC GPSS4N ======================== */
