/* =========================== START PROC IAME1 =========================== */
PROC (3) = IAME1(XGRID,Y,G,H,YSTART,NSTEP,TOL) ;
   /*  IMAGE ANALYSIS M-ESTIMATOR,  THIS IS "REAL" VERSION #1   */
   /*  THIS MODIFIES TEST #3, BY TAKING MAXSTEP = 2 * G,  */
   /*  BY NOT RETURNING THE Y VALUE FOR EACH STEP,   */
   /*  BY ALLOWING REAL REGRESSION DATA, WITH BANDWIDTHS  H  AND  G,  */
   /*  AND BY LOOPING THROUGH ALL  X  LOCATIONS.   */
   /*  THIS ASSUMES A GAUSSIAN KERNEL FUNCTION IN BOTH X AND Y DIRECTIONS  */
   /*  INPUTS ARE:                                                   */
   /*    XGRID        IS THE VECTOR OF X LOCATIONS FOR REGRESSION DATA  */
   /*    Y            IS THE VECTOR OF Y'S FOR REGRESSION DATA  */
   /*    G            IS THE BANDWIDTH IN THE Y DIRECTION  */
   /*    H            IS THE BANDWIDTH IN THE X DIRECTION  */
   /*    YSTART       IS THE VECTOR OF STARTING Y VALUES   */
   /*                      (E.G. COULD BE THE SAME AS Y'S)   */
   /*    NSTEP        IS THE LARGEST NUMBER OF STEPS ALLOWED   */
   /*                      (10 SEEMS TO WORK OK)                */
   /*    TOL         QUIT AFTER NEXT CHANGES BY LESS THAN TOL*G  */
   /*                      (TOL = 10^(-3) SEEMS QUITE ACCURATE)  */
   /*  RETURNS ARE:                                                  */
   /*    MHAT         VECTOR OF RESULTING ESTIMATES             */
   /*    VNSTEP       VECTOR OF NUMBERS OF STEPS TAKEN AT EACH X  */
   /*    VFLAG        VECTOR OF FLAGS AT EACH LOCATION    */
   /*                     0  FOR ORDINARY CONVERGENCE TO WITHIN TOL  */
   /*                     1  WHEN TOOK NSTEP STEPS WITHOUT CONVERGING  */
   /*                     -1 WHEN HIT "FLAT SPOT" AND COULD NOT PROCEED  */

 LOCAL NX,MHAT,VNSTEP,VFLAG,MAXSTEP,IX,YNEW,SIMPFLAG,NEWTFLAG,TOLFLAG,SSTEP,
         WTS,ISTEP,YOLD,ARG,K,M,DM,DDM,OSCFLAG,YSTEP ;

 NX = ROWS(XGRID) ;
 MHAT = ZEROS(NX,1) ;
 VNSTEP = ZEROS(NX,1) ;
 VFLAG = ZEROS(NX,1) ;

 MAXSTEP = 2 * G ;       /*  LARGEST STEP ALLOWED  */

 IX = 1 ;
 DO WHILE IX <= NX ;
   "." ;;

   YNEW = YSTART[IX] ;
   SIMPFLAG = 0 ;
   NEWTFLAG = 0 ;
   TOLFLAG = 1 ;
   SSTEP = MAXSTEP ;      /*  VERSION CAN SHRINK  */

   WTS = PDFN((XGRID[IX] - XGRID) / H) ;

   ISTEP = 1 ;
   DO WHILE  (ISTEP <= NSTEP)  AND  (TOLFLAG == 1) ;
     YOLD = YNEW ;

     ARG = (YOLD - Y')/G ;                /*  ARGUMENT OF KERNEL FUNCTION  */
     K = PDFN(ARG) ;                      /*  KERNEL FUNCTION  */
     M = -K * WTS ;                       /*  M-FUNCTION, I.E. - K. D. E.  */
     DM = (ARG .* K / G) * WTS ;          /*  DERIVATIVE OF M-FUNCTION  */
     DDM = ((1 - ARG.* ARG) .* K / G^2) * WTS ;
                                          /* 2ND DERIVATIVE OF M-FUNCTION */


     IF DDM <= 0 ;    /*  IN AREA OF LOCAL MAX  */

       IF DM > 0 ;          /*  GO LEFT TOWARDS MIN  */
         OSCFLAG = (SIMPFLAG[ISTEP] == 1) ;
         OSCFLAG = (OSCFLAG OR (NEWTFLAG[ISTEP] == - 1)) ;
         IF OSCFLAG == 1 ;                       /*  LAST STEP WAS RIGHT  */
           SSTEP = SSTEP / 2 ;                   /*  CUT OUT OSCILLATION  */
         ENDIF ;
         YNEW = YOLD - SSTEP ;
         SIMPFLAG = SIMPFLAG|-1 ;
       ELSEIF DM < 0 ;      /*  GO RIGHT TOWARDS MIN  */
         OSCFLAG = (SIMPFLAG[ISTEP] == -1) ;
         OSCFLAG = OSCFLAG OR (NEWTFLAG[ISTEP] == - 2) ;
         IF OSCFLAG == 1 ;                        /*  LAST STEP WAS LEFT  */
           SSTEP = SSTEP / 2 ;                    /*  CUT OUT OSCILLATION  */
         ENDIF ;
         YNEW = YOLD + SSTEP ;
         SIMPFLAG = SIMPFLAG|1 ;
       ELSE ;               /*  FLAT, FLAG THIS AND QUIT LOOP  */
         TOLFLAG = -1 ;
       ENDIF ;

       NEWTFLAG = NEWTFLAG|0 ;
     ELSE ;          /*  NEAR LOCAL MIN, DO NEWTON STEP  */

       YSTEP = - DM / DDM ;
       IF ABS(YSTEP) >= SSTEP ;     /*  YSTEP IS TOO BIG, TRUNCATE  */

         IF YSTEP .> 0 ;    /*  GOING TO THE RIGHT  */
           NEWTFLAG = NEWTFLAG|-1 ;
           OSCFLAG = (SIMPFLAG[ISTEP] == -1) ;
           OSCFLAG = OSCFLAG OR (NEWTFLAG[ISTEP] == - 2) ;
           IF OSCFLAG == 1 ;               /*  LAST STEP WAS LEFT AND BIG */
             SSTEP = SSTEP / 2 ;                  /*  CUT OUT OSCILLATION  */
           ENDIF ;
         ELSE ;             /*  GOING TO THE LEFT  */
           OSCFLAG = (SIMPFLAG[ISTEP] == 1) ;
           OSCFLAG = OSCFLAG OR (NEWTFLAG[ISTEP] == - 1) ;
           IF OSCFLAG == 1 ;               /*  LAST STEP WAS RIGHT AND BIG */
             SSTEP = SSTEP / 2 ;                  /*  CUT OUT OSCILLATION  */
           ENDIF ;
           NEWTFLAG = NEWTFLAG|-2 ;
         ENDIF ;

         YSTEP = SSTEP * YSTEP / ABS(YSTEP) ;
       ELSE ;
         NEWTFLAG = NEWTFLAG|1 ;
       ENDIF ;
       YNEW = YOLD + YSTEP ;

       SIMPFLAG = SIMPFLAG|0 ;
     ENDIF ;


     IF ABS(YNEW - YOLD) .< (TOL * G) ;      /*  Y'S ARE VERY CLOSE, SO QUIT  */
       TOLFLAG = 0 ;
     ELSE ;
       ISTEP = ISTEP + 1 ;
     ENDIF ;
   ENDO ;
   MHAT[IX] = YNEW ;
   VNSTEP[IX] = ISTEP ;
   VFLAG[IX] = TOLFLAG ;

  IX = IX + 1 ;
ENDO ; ? ;

 RETP(MHAT,VNSTEP,VFLAG) ;
ENDP ;
/* ============================ END PROC IAME1 ============================ */
