/* =========================== START PROC IAME2 =========================== */
PROC (3) = IAME2(XGRID,Y,G,H,NSTEP,TOL) ;
   /*  IMAGE ANALYSIS M-ESTIMATOR,  THIS IS "REAL" VERSION #2   */
   /*  ESSENTIALLY SAME AS IAMET6   */
   /*  THIS ASSUMES A GAUSSIAN KERNEL FUNCTION IN BOTH X AND Y DIRECTIONS  */
   /*  INPUTS ARE:                                                   */
   /*    XGRID        IS THE VECTOR OF X LOCATIONS FOR REGRESSION DATA  */
   /*    Y            IS THE VECTOR OF Y'S FOR REGRESSION DATA  */
   /*    G            IS THE BANDWIDTH IN THE Y DIRECTION  */
   /*    H            IS THE BANDWIDTH IN THE X DIRECTION  */
   /*    NSTEP        IS THE LARGEST NUMBER OF STEPS ALLOWED    */
   /*                      FOR ADJUSTMENT TO LOCAL LINEAR FIT   */
   /*                            (15 SEEMS TO WORK OK)                */
   /*    TOL         QUIT AFTER NEXT CHANGES BY LESS THAN        */
   /*                      TOL*G  FOR THE PRELIMINARY LOCAL CONSTANT   */
   /*                      TOL*SQRT(G^2+H^2)  FOR THE ADJ. TO LOC. LIN.   */
   /*                      (TOL = 10^(-3) SEEMS QUITE ACCURATE)  */
   /*  RETURNS ARE:                                                  */
   /*    MHAT         VECTOR OF RESULTING ESTIMATES             */
   /*    VNSTEP       VECTOR OF NUMBERS OF STEPS TAKEN AT EACH X   */
   /*                        FOR LOCAL LINEAR PART       */
   /*    VFLAG        VECTOR OF FLAGS AT EACH LOCATION    */
   /*                     0  FOR ORDINARY CONVERGENCE TO WITHIN TOL  */
   /*                     1  WHEN TOOK NSTEP STEPS WITHOUT CONVERGING   */

 LOCAL NX,MHAT,VNSTEP,VFLAG,RSTEPF,MAXANG,IX,
         XDIF,ARGX,XWTS,WTS,YDIF,ARGY,S0,S1,S2,T0,T1,BNEW,ANEW,
         MAXSTEP,SIMPFLAG,NEWTFLAG,SSTEP,SANG,
         DIRVOLD,MINFLAG,MOLD,M,DM,
         DMOLD,LSTEPOLD,SGNANG,
         ISTEP,TOLFLAG,AOLD,BOLD,K,M1,M2,M11,M22,M12,D,
         ASTEP,BSTEP,DIRV,SDDIR,
         A,QT,QB,ANGOLD,ANGNEW,SGNANGN,DOP,DIRDOP,
         LMIN,LSTEP,B,C,QFLAG ;

 NX = ROWS(XGRID) ;
 MHAT = ZEROS(NX,1) ;
 VNSTEP = ZEROS(NX,1) ;
 VFLAG = ZEROS(NX,1) ;

 RSTEPF = 1 ;         /*  IN LOCAL LINEAR PART, REDUCE STEP SIZE BY
                                 THIS FACTOR  */
/*  THINK CAREFULLY ABOUT THIS ONE  */
 MAXANG = PI / 4 ;         /*  IN LOCAL LINEAR PART, THIS THE MAXIMUM
                                   ANGLE (IN RADIANS) ALLOWED IN
                                   CONJUGATE GRADIENT STEPS  */
/*  THINK CAREFULLY ABOUT THIS ONE  */

 IX = 1 ;
 DO WHILE IX <= NX ;
   "." ;;

   XDIF = XGRID[IX] - XGRID ;
   ARGX = XDIF / H ;
   XWTS = PDFN(ARGX) ;
   YDIF = Y[IX] - Y ;
   ARGY = YDIF / G ;
   WTS = XWTS .* PDFN(ARGY) ;

   S0 = SUMC(WTS) ;
   S1 = SUMC(WTS .* (-XDIF)) ;
   S2 = SUMC(WTS .* (-XDIF) .* (-XDIF)) ;
   T0 = SUMC(WTS .* Y) ;
   T1 = SUMC(WTS .* Y .* (-XDIF)) ;

   D = (S0 * S2 - S1 * S1) ;
   IF ABS(D) == 0 ;     /*  LOCAL LINEAR FIT FAILS  */
     ? ;
     "***************************************************" ;
     "***  CAREFUL, LOCAL LINEAR SIGMA FITLER FAILED  ***" ;
     "***      USING LOCAL CONSTANT SIGMA FITLER      ***" ;
     "***************************************************" ;
     BNEW = 0 ;
     ANEW = T0 / S0 ;
   ELSE ;
     BNEW = (S0 * T1 - S1 * T0) / D ;
     ANEW = (T0 - S1 * BNEW) / S0 ;
   ENDIF ;

   ARGY = (Y' - (ANEW + BNEW * -XDIF'))/G ;    /* ARG OF KERNEL FUNCTION */
   K = PDFN(ARGY) ;                           /*  KERNEL FUNCTION  */
   MOLD = -K * XWTS ;                   /*  M-FUNCTION, I.E. - K. D. E.  */


   MAXSTEP = G ;           /*  LARGEST STEP ALLOWED  */
/*     THINK CAREFULLY ABOUT SCALE  */

   SIMPFLAG = 0 ;
   NEWTFLAG = 0 ;
   TOLFLAG = 1 ;
   SSTEP = MAXSTEP ;      /*  VERSION CAN SHRINK  */
   SANG = MAXANG ;      /*  VERSION CAN SHRINK  */

   DIRVOLD = 1|0 ;
   MINFLAG = 1 ;        /*  SINCE JUST MIN'D IN X DIRECTION   */
   DM = BNEW ;           /*  LAST VALUE OF M    */
/*
*/
   DMOLD = -1 ;         /*  NOT USED ANYWHERE  */
   LSTEPOLD = 1 ;         /*  NOT USED ANYWHERE  */
   SGNANG = 0 ;

   ISTEP = 1 ;
   TOLFLAG = 1 ;
   DO WHILE  (ISTEP <= NSTEP)  AND  (TOLFLAG == 1) ;
     AOLD = ANEW ;
     BOLD = BNEW ;

     ARGY = (Y' - (AOLD + BOLD * -XDIF'))/G ;    /* ARG OF KERNEL FUNCTION */
     K = PDFN(ARGY) ;                           /*  KERNEL FUNCTION  */
     M = -K * XWTS ;                   /*  M-FUNCTION, I.E. - K. D. E.  */

     M1 = (-ARGY .* K / G) * XWTS ;
     M2 = (-XDIF' .* (-ARGY) .* K / G) * XWTS ;
     M11 = ((1 - ARGY.* ARGY) .* K / G^2) * XWTS ;
     M22 = (XDIF'^2 .* (1 - ARGY.* ARGY) .* K / G^2) * XWTS ;
     M12 = (-XDIF' .* (1 - ARGY.* ARGY) .* K / G^2) * XWTS ;
     D = M22 * M11 - M12^2 ;


     IF  (M11 > 0)  AND  (M22 > 0)  AND  (D > 0);
                                  /*  NB'HD OF LOCAL MIN,    */
                                  /*  DO SOME NEWTON TYPE STEP   */

       ASTEP = (M12 * M2 - M22 * M1) / D ;
       BSTEP = (M12 * M1 - M11 * M2) / D ;

       IF SQRT(ASTEP^2 + BSTEP^2) > SSTEP ;   /* NEWTON STEP TOO BIG */
/*  THINK MORE CAREFULLY ABOUT RELATIVE SCALES OF A AND B  */
         ASTEP = SSTEP * ASTEP / SQRT(ASTEP^2 + BSTEP^2) ;
         BSTEP = SSTEP * BSTEP / SQRT(ASTEP^2 + BSTEP^2) ;
         MINFLAG = 0 ;      /*  DIDN'T MINIMIZE THIS DIRECTION  */

       ELSE ;        /*  NEWTON STEP SIZE OK, TAKE THAT  */
         MINFLAG = 1 ;      /*  DID MINIMIZE THIS DIRECTION  */

       ENDIF ;

       DIRV = (ASTEP|BSTEP) / SQRT(ASTEP^2 + BSTEP^2) ;
       DIRVOLD = DIRV ;

     ELSE ;     /*  NEWTON FAILED, MIN THIS DIRECTION,   */
                /*  OR TAKE CONJUGATE GRADIENT STEP   */

       SDDIR = (-M1)|(-M2) ;

       IF MINFLAG == 1 ;       /*  LAST STEP MIN'D IN THAT DIRECTION  */
                               /*  SO LOOK FOR NEW DIRECTION VECTOR  */
                               /*  AND MAKE CONJUGATE GRADIENT STEP  */
         A = (M11~M12)|(M12~M22) ;
         QT = SDDIR' * A * DIRVOLD ;
         QB = DIRVOLD' * A * DIRVOLD ;
         IF ABS(QT) < (1 - TOL) * SQRT( (SDDIR'*A*SDDIR) * QB ) ;
                          /*  I.E. DIRV AND SDDIR NOT IN SAME DIRECTION  */
           DIRV = SDDIR - (QT / QB) * DIRVOLD ;
         ELSE ;       /*  DIRECTIONS SAME, USE STEEPEST DESCENT  */
           DIRV = SDDIR ;
         ENDIF ;
         DIRV = DIRV / SQRT(DIRV' * DIRV) ;

         ANGOLD = ARCCOS(DIRVOLD[1]) + ((DIRVOLD[1] < 0) * PI) ;
         ANGNEW = ARCCOS(DIRV[1]) + ((DIRV[1] < 0) * PI) ;
         SGNANGN = (ANGNEW > ANGOLD) - (ANGNEW < ANGOLD) ;

         IF ABS(SGNANGN - SGNANG) > 1.5  ;
                     /*  HAVE REVERSED DIRECTION, SO REDUCE ANGLE  */
           SANG = SANG / 2 ;
         ENDIF ;

         IF DIRV' * DIRVOLD < COS(SANG)  AND  ISTEP > 1 ;
                              /*  IF NEW DIRECTION TOO FAR FROM OLD   */
           DOP = DIRVOLD[2]|(-DIRVOLD[1]) ;
           DIRDOP = DIRV' * DOP ;
           DIRDOP = DIRDOP / ABS(DIRDOP) ;
           DOP = DIRDOP * DOP ;
           DIRV = COS(SANG) * DIRVOLD + SIN(SANG) * DOP ;
         ENDIF ;

         ASTEP = SSTEP * DIRV[1] ;
         BSTEP = SSTEP * DIRV[2] ;

         SSTEP = SSTEP * RSTEPF ;     /*  REDUCE STEP SIZE  */

         DM = DIRV' * (M1|M2) ;       /*  DIRECTIONAL DERIVATIVE, IN   */
                                      /*  DIRV DIRECTION  */

         SGNANG = SGNANGN ;

         DIRVOLD = (ASTEP|BSTEP) / SQRT(ASTEP^2 + BSTEP^2) ;

         MINFLAG = 0 ;      /*  DIDN'T MINIMIZE THIS DIRECTION  */

       ELSE ;                 /*  NO MIN LAST TIME, SO MIN IN THE  */
                              /*  SAME DIRECTION AGAIN  */

         DM = DIRV' * (M1|M2) ;       /*  DIRECTIONAL DERIVATIVE, IN   */
                                      /*  DIRV DIRECTION  */

         IF M >= MOLD ;           /*  CURRENT VALUE FARTHER FROM MIN  */
           B = DMOLD ;
           C = 2 * (M - MOLD - DMOLD * LSTEPOLD) / LSTEPOLD^2 ;
         ELSE ;                   /*  OLD VALUE CLOSER TO MIN  */
           B = 2 * (M - MOLD) / LSTEPOLD - DM ;
           C = 2 * (MOLD - M + DM * LSTEPOLD) / LSTEPOLD^2 ;
         ENDIF ;
         IF C <= 0 ;       /*  HAVE ROTTEN PARABOLIC FIT  */
           LSTEP = SSTEP ;
           MINFLAG = 0 ;      /*  DIDN'T MINIMIZE THIS DIRECTION  */
         ELSE ;            /*  PARABOLIC FIT OK  */
           LMIN = -B / C ;

           IF LMIN <= LSTEPOLD + SSTEP ;    /*  STEP IS NOT TOO BIG  */
             IF LMIN > 0 ;                   /*  STEP IS NOT BACKWARDS  */
               LSTEP = LMIN - LSTEPOLD ;     /*  STEP FROM NEW VALUE  */
               MINFLAG = 1 ;      /*  DID MINIMIZE THIS DIRECTION  */

             ELSE ;         /*  STEP BACKWARDS, SO BISECT  */
               LSTEP = -LSTEPOLD / 2 ;
               MINFLAG = 0 ;      /*  DIDN'T MINIMIZE THIS DIRECTION  */

             ENDIF ;
           ELSE ;         /*  STEP TOO BIG SO TRUNCATE  */
             LSTEP = SSTEP ;
             MINFLAG = 0 ;      /*  DIDN'T MINIMIZE THIS DIRECTION  */

           ENDIF ;
         ENDIF ;

         ASTEP = LSTEP * DIRV[1] ;
         BSTEP = LSTEP * DIRV[2] ;

       ENDIF ;
     ENDIF ;


     ANEW = AOLD + ASTEP ;
     BNEW = BOLD + BSTEP ;
     LSTEPOLD = SQRT(ASTEP^2 + BSTEP^2) ;


     QFLAG = ABS(LSTEPOLD) .< (TOL * G) ;
                      /*  QUIT WHEN STEP LENGTH IS SHORT  */
     QFLAG = QFLAG  AND  MINFLAG ;
                      /*  ALSO MAKE SURE LAST STEP DID A MINIMIZATION  */
     IF QFLAG ;
       TOLFLAG = 0 ;
     ELSE ;
       ISTEP = ISTEP + 1 ;
       MOLD = M ;
       DMOLD = DM ;
     ENDIF ;
   ENDO ;
   VNSTEP[IX] = ISTEP ;


   MHAT[IX] = ANEW ;
   VNSTEP[IX] = ISTEP ;
   VFLAG[IX] = TOLFLAG ;

   IX = IX + 1 ;
 ENDO ; ? ;

 RETP(MHAT,VNSTEP,VFLAG) ;
ENDP ;
/* ============================ END PROC IAME2 ============================ */

