/**********************************************************************/
/* makemon2W **********************************************************/
/**********************************************************************/
/* Function: makemon1 transforms a vector into a monoton *increasing* */
/*           sequence via the pool adjectant violator algorithm       */
/*                                                                    */
/* Basic Algorithm:                                                   */
/*  1) Find two points which violate the monotonicity.                */
/*  2) If no such points exist we are done.                           */
/*  3) If they exist then we replace them by their average.           */
/*  4) Now we check to the left if we have introduced by this         */
/*     averaging a new violation of the monotonicity. If so average   */
/*     again.                                                         */
/*  5) Then we check to the right if we have introduced a (new)       */
/*     violation of the monotonicity. If so continue to average       */
/*  6) Finally we go again to 1)                                      */
/*                                                                    */
/* Call:     y = makemon2(x)                                          */
/*                                                                    */
/* ->X      x    n x 1 matrix, with the observed variable             */
/* ->W      W    N X 1 MATRIX, WITH WEIGHTS                           */
/*                                                                    */
/* X->      y    n x 1 matrix, the monotone increasing sequence       */
/*                             calculated from the input x            */
/*                                                                    */
/**********************************************************************/
/* Berwin A. Turlach 940731 *******************************************/
/* TURNED FROM MAKMON2 TO MAKMON2W BY J. S. MARRON                    */
/**********************************************************************/
proc makmon2W(x,W);
local left,        /* left point  violating monotonicity       */
      right,       /* right point violating monotonicity       */
      ave,         /* average of the points                    */
      nave,        /* number of points involved in the average */
      n,           /* total number of observation              */
      vind,        /* index holding the violaters              */
      eqind,       /* index with points to the left/right      */
                   /* which are equal to the left/right point  */
      noe,         /* number of points to the left/right which */
                   /* are equal                                */
      CW,          /* CUMULATIVE SUM OF W, FOR QUICK SUMS      */
      W1,          /* TEMPORARY WEIGHT VARIABLE                */
      W2;          /* TEMPORARY WEIGHT VARIABLE                */

  n  = rows(x);

  CW = CUMSUMC(W) ;

  /* which points violate monotonicity? */
  vind = x[1:n-1] .> x[2:n];

  /* pool adjactent violaters as long as they exists */
  do while sumc(vind);
    left  = maxindc(vind);           /* get the first violator */
    right = left+1;

    /* average the violators and replace them by the average */
/*    ave   = (x[left] + x[right]) / 2;  */
    AVE = (W[LEFT] * X[LEFT] + W[RIGHT] * X[RIGHT]) / (W[LEFT] + W[RIGHT]) ;
    nave  = 2;
    x[left:right] = ones(nave,1) * ave;

    /* check if we have produced by the above averaging a violation */
    /* on the left of the current place.                            */
    do while (left>1);
      if (x[left-1] <= x[left]);
        break;
      else;
        /* check how many elements to the left are equal (and       */
        /* bigger than our above average)                           */
        left  = left - 1;
        eqind = rev(x[1:left] .== x[left]);
        noe   = minindc(eqind);  /* saveguard if the elments to the */
                                 /* left are not yet monotone       */
        if noe==1;               /* if noe==1 then all elements to  */
          noe = left;            /* the left are equal              */
        else;
          noe = noe-1;           /* noe points to the element       */
                                 /* _before_ the run of equal       */
                                 /* elements and is thus one to big */
        endif;
        /* recalculate (weighted) average and replace */
/*        ave   = (noe*x[left] + nave*x[left+1]) / (nave+noe);  */
          IF LEFT == NOE ;     /* LEFT GROUP GOES TO BOUNDARY  */
            W1 = CW[LEFT] ;
          ELSE ;
            W1 = CW[LEFT] - CW[LEFT-NOE] ;
          ENDIF ;
          W2 = CW[LEFT+NAVE] - CW[LEFT] ;
        AVE = (W1 * X[LEFT] + W2 * X[LEFT+1]) / (W1 + W2) ;
        left  = left-noe+1;
        nave  = nave+noe;
        x[left:right] = ones(nave,1) * ave;
      endif;
    endo;

    /* check if we have produced by the above averaging a violation */
    /* on the right of the current place.                           */
    do while (right<n);
      if (x[right] <= x[right+1]);
        break;
      else;
        /* check how many elements to the right are equal (and      */
        /* bigger than our above average)                           */
        right = right + 1;
        eqind = x[right:n] .== x[right];
        noe   = minindc(eqind);   /* saveguard if the elments to the */
                                  /* right are not yet monotone      */
        if noe == 1;              /* if noe==1 then all elements to  */
          noe = n-right+1;        /* the right are equal             */
        else;
          noe = noe - 1;          /* noe points to the element       */
                                  /* _after_ the run of equal        */
                                  /* elements and is thus one to big */
        endif;
        /* recalculate (weighted) average and replace */
/*        ave   = (noe*x[right] + nave*x[right-1]) / (nave+noe);  */
          IF RIGHT-NAVE-1 == 0 ;
            W1 = CW[RIGHT-1] ;
          ELSE ;
            W1 = CW[RIGHT-1] - CW[RIGHT-NAVE-1] ;
          ENDIF ;
          W2 = CW[RIGHT+NOE-1] - CW[RIGHT-1] ;
        AVE = (W1 * X[RIGHT-1] + W2 * X[RIGHT]) / (W1 + W2) ;
        right = right+noe-1;
        nave  = nave+noe;
        x[left:right] = ones(nave,1) * ave;
       endif;
    endo;

    /* are there still violators ? */
    vind = x[1:n-1] .> x[2:n];  /* anymore violators? */
  endo;

  retp(x);
endp;
/*========================== END MAKMON2W.G ==========================*/

