/* =========================== START PROC MINGRAY1 ========================= */
PROC (1)=MINGRAY1(Y,IPAR) ;
    /*  THIS CALCULATES PATH WITH MINIMUM SUM OF GRAY LEVELS   */
    /*  THE PATH IS "8 CONNECTED", AND HAS ONE SUMMAND IN EACH COL  */
    /*  INPUTS ARE:           */
    /*        Y - INPUT MATRIX, OF GRAY LEVELS AT PIXELS    */
    /*                 (REQUIRES AT LEAST 3 ROW AND COLS)     */
    /*        IPAR - CONTROL PARAMETER:    */
    /*                        1 - TO RETURN BOTH MIN'ING VALUE, AND   */
    /*                                 ALSO INDICES OF MIN'ING PATH  */
    /*                        2 - TO RETURN ONLY MINING SUM      */
    /*  OUTPUT IS:               */
    /*       IPAR = 1:    A VECTOR, WITH ENTRIES:       */
    /*                 1         SY -  THE MINIMIZING SUM     */
    /*                 2:NC+1   IND - THE VECTOR OF INDICES      */
    /*       IPAR = 2:    THE SCALAR,       SY -  THE MINIMIZING SUM   */

  LOCAL NR,NC,MSY,IC,ARG1,ARG2,ARG3,VSY,SY,IND,VIND,ARG ;

  NR = ROWS(Y) ;
  NC = COLS(Y) ;

          /*  FIRST PASS CREATES PIXEL BY PIXEL  */
          /*         MATRIX OF MINIMIZING SUMS TOWARDS LEFT  */
  MSY = Y[.,1] ;
  IC = 2 ;
  DO WHILE IC <= NC ;
    ARG2 = Y[1,IC] + MSY[1,IC-1] ;
    ARG3 = Y[1,IC] + MSY[2,IC-1] ;
    VSY = MINC(ARG2|ARG3) ;

    ARG1 = Y[2:(NR-1),IC] + MSY[1:(NR-2),(IC-1)] ;
    ARG2 = Y[2:(NR-1),IC] + MSY[2:(NR-1),(IC-1)] ;
    ARG3 = Y[2:(NR-1),IC] + MSY[3:NR,(IC-1)] ;
    VSY = VSY|MINC((ARG1')|(ARG2')|(ARG3')) ;

    ARG1 = Y[NR,IC] + MSY[(NR-1),(IC-1)] ;
    ARG2 = Y[NR,IC] + MSY[NR,(IC-1)] ;
    VSY = VSY|MINC(ARG2|ARG2) ;

    MSY = MSY~VSY ;

    IC = IC + 1 ;
  ENDO ;


  SY = MINC(MSY[.,NC]) ;


          /*  SECOND PASS GETS INDICES OF PATH  */
  IF IPAR == 1 ;       /*  GET MIN'ING PATH AS WELL  */
    IND = MININDC(MSY[.,NC]) ;    /*  INDEX OF MINIZER */
    VIND = IND ;
    IC = NC - 1 ;
    DO WHILE IC >= 1 ;
      IF IND == 1 ;
        ARG = MSY[1:2,IC] ;
        IND = MININDC(ARG) ;           /*   1 OR 2   */
      ELSEIF IND == NR ;
        ARG = MSY[(NR-1):NR,IC] ;
        IND = MININDC(ARG) + (NR - 2) ;    /*  NR-1 OR NR   */
      ELSE ;
        ARG = MSY[(IND-1):(IND+1),IC] ;
        IND = MININDC(ARG) + (IND - 2) ;
                      /*  SAME VALUE WHEN MIN IN MIDDLE   */
      ENDIF ;

      VIND = IND|VIND ;
      IC = IC - 1 ;
    ENDO ;
  ENDIF ;


  IF IPAR == 1 ;
    RETP(SY|VIND) ;
  ELSEIF IPAR == 2 ;
    RETP(SY) ;
  ENDIF ;
ENDP;
/* ====================== END PROCEDURE MINGRAY1 =========================== */

