/*  C:\GAUSS\PRG\MINRP.PRC  */

         /*  MINIMIZING PROCEDURE   */
                   /*  THE ARGUMENTS ARE THE X AND Y COORDINATES OF A FUNCTION
                       FOR WHICH IT IS DESIRED TO FIND THE MIN'R (IN CASE OF
                       MULTIPLE MINS, IT FINDS THE LAST ONE
                       THIS ASSUMES THE X'S ARE ORDERED
                       RETURNED VALUE IS A VECTOR CONTAINING THE MINIMIZING
                       VALUE, -1,0,1,5 TO INDICATE IF ENDPOINTS ARE HIT
                       OR A STRANGE QUADRATIC FIT WAS ENCOUNTERED, AND
                       THE NUMBER OF LOCAL MINIMA   */
PROC (1)=MINRP(X,Y) ;
   LOCAL NX, YMAX2, DIFS, POSFLAG, NEGFLAG, MINFLAG, NMIN, IMIN, XX, YY ;
   LOCAL MX, COEFF, XMIN ;
   NX = ROWS(X) ;
     YMAX2 = 2 * MAXC(ABS(Y)) ;
     DIFS = (Y|YMAX2) - (YMAX2|Y) ;
     POSFLAG = (DIFS .>= 0) ;    /*  FLAG WHERE DIFS ARE POSITIVE  */
     NEGFLAG = (DIFS .<= 0) ;    /*  FLAG WHERE DIFS ARE NEGATIVE  */
     MINFLAG = (1|NEGFLAG) .* (POSFLAG|1) ;    /*  FLAGS LOCAL MINIMA   */
     NMIN = SUMC(MINFLAG) ;               /*  NUMBER OF LOCAL MINIMA  */
     IMIN = NX + 2 - MAXINDC(REV(MINFLAG))  ;  /*  INDEX OF LAST MIN  */
   IF IMIN <= 1 ;
      "  LEFT END WAS HIT" ;
      RETP(X[1,1]|-1|NMIN) ;  /*  MINRP, ENDPT FLAG, NUMBER OF JUMPS  */
   ELSEIF IMIN >= NX ;
      "  RIGHT END WAS HIT" ;
      RETP(X[NX,1]|1|NMIN) ;  /*  MINRP, ENDPT FLAG, NUMBER OF JUMPS  */
   ELSE ;
             /*  FIT A PARABOLA TO THE ABOVE SELECTED VALUES  */
      XX = X[(IMIN-1):(IMIN+1),1] ;
      YY = Y[(IMIN-1):(IMIN+1),1] ;
      MX = (XX.*XX)~XX~ONES(3,1) ;
      COEFF = INV(MX) * YY ;
      XMIN = -COEFF[2,1] / (2 * COEFF[1,1]) ;
      IF XMIN <= XX[3,1] AND XMIN >= XX[1,1] ;
         RETP(XMIN|0|NMIN) ;
      ELSE ;
         RETP(XX[2,1]|5|NMIN) ;
      ENDIF;
   ENDIF ;
ENDP ;

