/* =========================== START PROC MSQRT ======================= */
PROC MSQRT(X) ;
   /*  THIS CALCULATES THE SYMMETRIC SQUARE ROOT OF    */
   /*  A NONEGATIVE DEFINITE SQAURE MATRIX   */
   /*  APPLICATION:           */
   /*       TO GENERATE MULTIVARIATE DATA WITH GIVEN   */
   /*       COVARIANCE MATRIX, APPLY THIS TO COVARIANCE MATRIX,   */
   /*       THEN MULTIPLY BY INDEPENDENT DATA    */
   /*  INPUTS:            */
   /*    X - NONNEGATIVE DEFINITE MATRIX     */
   /*  OUTPUT:           */
   /*    RX - SYMMETRIC SQUARE ROOT OF X       */

 LOCAL U,S,V,RX ;

 {U,S,V} = SVD1(X) ;
 RX = U * SQRT(S) * V' ;

 RETP(RX) ;
ENDP ;
/* ============================ END PROC MSQRT ======================= */

