/*************** PROC MWhise.g **************/

PROC MWhise(bincnts,lbctr,rbctr,mu,sig2,w,kord,hfactor,nhgrid,hacc,nhstep) ;

/*  This calculates the minimizer of ISE using normal kernel of
    order kord for a normal mixture density kord = 2,4,6...
    An initial gridsearch is done on [h_AMISE/hfactor, h_AMISE*hfactor]  */
/*  WRITTEN BY MATT WAND  */

    /*                  hfactor <= 1 skips gridsearch  */
    /*  nhgrid is number of gridpoints for search  */
    /*                  nhgrid <= 1 skips gridsearch  */
    /*  hacc is accuracy for newton's method improvement  */
    /*  nhstep is maximum number of steps for newton's method improvement  */

   LOCAL n,hamise,shgrid,ehgrid,inch,hgrid,iseval,ho,i,oise,hn,iseval,isedval,
         iseddval ;

   n = SUMC(bincnts) ;

   "CALCULATING h_AMISE" ;

   hamise = nmamisem(n,mu,sig2,w,kord) ;
   hamise = hamise[1,1] ;

   IF (hfactor > 1 and nhgrid > 1) ;
      "DOING INITIAL GRIDSEARCH" ;
      shgrid = hamise / hfactor ;
      ehgrid = hamise * hfactor ;
      inch = (ehgrid/shgrid)^(1/(nhgrid - 1)) ;
      hgrid = SEQM(shgrid,inch,nhgrid) ;
      "CALCULATING ISE" ;
      iseval = MWise(bincnts,lbctr,rbctr,hgrid,mu,sig2,w,kord) ;
      ho = hgrid[minindc(iseval),1] ;
   ELSE ;
      ho = hamise ;
   ENDIF ;

  "DO NEWTON'S METHOD IMPROVEMENT" ;
   i = 0 ;
   isedval = MWised(bincnts,lbctr,rbctr,ho,mu,sig2,w,kord) ;
   iseddval = MWisedd(bincnts,lbctr,rbctr,ho,mu,sig2,w,kord) ;
   oise = MWise(bincnts,lbctr,rbctr,ho,mu,sig2,w,kord) ;
   FORMAT 10,6 ;
  " STEP " i ", H = " ho ", ISE = " oise ;

   DO WHILE i <= nhstep ;
      i = i + 1 ;

      /*  Update  */

      hn = ho - isedval / iseddval ;

      isedval = MWised(bincnts,lbctr,rbctr,hn,mu,sig2,w,kord) ;
      iseddval = MWisedd(bincnts,lbctr,rbctr,hn,mu,sig2,w,kord) ;
      iseval = MWise(bincnts,lbctr,rbctr,hn,mu,sig2,w,kord) ;

                /*  Make sure hn is not worse  */

/********************************************************
******* THIS BIT SEEMS TO SCREW THINGS UP SOMETIMES *****
********         SO HAS BEEN OMITTED               ******
*********************************************************

      DO WHILE (iseval > oise) OR (hn < 0) ;
      "          READJUSTED BECAUSE ISE GOT WORSE, OR H < 0    " ;
         hn = (ho + hn) / 2 ;
         isedval = MWised(bincnts,lbctr,rbctr,hn,mu,sig2,w,kord) ;
         iseddval = MWisedd(bincnts,lbctr,rbctr,hn,mu,sig2,w,kord) ;
         iseval = MWise(bincnts,lbctr,rbctr,hn,mu,sig2,w,kord) ;
      ENDO ;

*********************************************************
*********************************************************/

      FORMAT 10,6 ;
      " STEP " i ", H = " hn ", ISE = " iseval ;

            /*  ACCURATE ENOUGH?  */

      IF ABS(hn - ho) <= hacc ;
         BREAK ;             /*  Jump out of loop  */
      ENDIF ;

      ho = hn ;
      oise = iseval ;

   ENDO ;

   RETP(hn|iseval) ;
ENDP ;

/*************** End PROC hise.g ***************/
