/**************** PROC MWise.g ***************/

PROC MWise(bincnts,lbctr,rbctr,hgrid,mu,sig2,w,kord) ;

/* This computes ISE(h) based on bin counts for a sample from
   normal mixture density using a Gaussian based kernel of order kord. */
/*  WRITTEN BY MATT WAND  */

   LOCAL r,h,wt,sll,arg,narg,intf2,ih,intfh2,h1,sh1,kernel,is,isd,stkern,
         mulbin,hell,shell,coeff,ip,ell,hp,hpn,xkernel,curvest,cross,isevec,
         nbin,n ;

/* Compute h-independent quantities. */

   r = kord / 2 ;
   n = SUMC(bincnts) ;
   nbin = ROWS(bincnts) ;
   wt = CONV(bincnts,REV(bincnts),nbin,2*nbin-1) ;
   wt[2:nbin,1] = 2 * wt[2:nbin,1] ;          /* Number of obs for each
                                                   kernel evaluation */
   sll = SQRT(sig2' + sig2) ;
   arg = (mu' - mu) ./ sll ;
   narg = norm(arg) ;
   intf2 = w' * (narg ./ sll) * w ;   /* Integral of f squared. */

   ih = 1 ; isevec = hgrid ;
   FORMAT /RD 4,0 ;
   DO WHILE ih <= ROWS(hgrid) ;
      IF ih/5 == FLOOR(ih/5) ; "WORKING ON H NUMBER " ih ; ENDIF ;
      h = hgrid[ih,1] ;

      /* Calculate the contribution due to the integrated square of the
         density estimate. */

      intfh2 = 0 ;
      h1= SQRT(2) * h ;
      sh1 = h1 * nbin / (rbctr - lbctr) ;
      arg = SEQA(0,1,nbin) / sh1 ;
      kernel = norm(arg) ;
      stkern = kernel ;

      is = 0 ;              /* s in the paper. */
      DO WHILE is<= r - 1 ;
         isd = 0 ;          /* s' in the paper. */
         DO WHILE isd<= r - 1 ;
            coeff = ((-1)^(is+isd'))/((2^(2*is+2*isd+1/2))*(is!)*(isd!)) ;
            kernel = stkern ;

            hp = 1 ;       /*  0th Hermite polynomial */
            hpn = arg ;    /*  1st Hermite polynomial */

            ip = 1 ;
            DO WHILE ip <= (is + isd) ;
               hp = arg .* hpn - (2*ip - 1) * hp ;   /* (2ip)th Hermite
                                                        polynomial. */
               hpn = arg .* hp - (2*ip) * hpn ;   /*  (2ip+1)th Hermite
                                                      polynomial. */
               ip = ip + 1 ;
            ENDO ;

            kernel = kernel .* hp ;  /* the (2s+2s')th derivative of phi. */

            intfh2 = intfh2 + coeff * wt' * kernel ;
            isd = isd + 1 ;
         ENDO ;
         is = is + 1 ;
      ENDO ;

      intfh2 = intfh2 / (n^2 * h) ;

      /* Now compute the cross-product term. */

      ell = 1 ;
      cross = 0 ;
      DO WHILE ell <= ROWS(w) ;
         hell = SQRT( sig2[ell,1] + h^2 ) ;
         shell = hell * nbin / (rbctr - lbctr) ;
         arg = SEQA(1-nbin,1,2*nbin-1) / shell ;
         xkernel = norm(arg) ;

         is = 0 ;
         DO WHILE is <= r - 1 ;

            hp = 1 ;       /*  0th Hermite polynomial */
            hpn = arg ;    /*  1st Hermite polynomial */
            ip = 1 ;
            DO WHILE ip <= is ;
               hp = arg .* hpn - (2*ip - 1) * hp ;   /* (2ip)-th Hermite
                                                        polynomial. */
               hpn = arg .* hp - (2*ip) * hpn ;   /*  (2ip+1)-th Hermite
                                                         polynomial. */
               ip = ip + 1 ;
            ENDO ;

            xkernel = xkernel .* hp ;  /* 2s'th derivative of phi. */
            curvest = CONV(bincnts,xkernel,,nbin,2*nbin-1) ;
            mulbin = FLOOR(nbin*(mu[ell,1]-lbctr) / (rbctr-lbctr)) ;
            cross = cross+
                    w[ell,1]*(h^(2*is))*curvest[mulbin,1] / hell^(2*is + 1 ) ;
            is = is + 1 ;
         ENDO ;
         ell = ell + 1 ;
      ENDO ;

      cross = -2*cross / n ;

      isevec[ih,1] = intfh2 + cross + intf2 ;

      ih = ih + 1 ;
   ENDO ;
   RETP(isevec) ;

ENDP ;

/*************** END PROC MWise.g ***************/
