/**************** PROC MWisedd.g ***************/

PROC MWisedd(bincnts,lbctr,rbctr,hgrid,mu,sig2,w,kord) ;

/* This computes (d2/dh2)ISE(h) based on bin counts for a sample from
   normal mixture density using a Gaussian based kernel of order kord. */
/*  WRITTEN BY MATT WAND  */

   LOCAL r,n,h,wt,arg,ih,ifh2d,h1,sh1,kernel,kern1,kern2,kern3,is,isd,
         mulbin,hell,shell,coeff,ip,ell,hp,hpn,xkernel,cross,iseddvec,
         nbin,xkern1,xkern2,xkern3,curv1,curv2,curv3,term ;

/* Compute h-independent quantities. */

   r = kord / 2 ;
   n = SUMC(bincnts) ;
   nbin = ROWS(bincnts) ;
   wt = CONV(bincnts,REV(bincnts),nbin,2*nbin-1) ;
   wt[2:nbin,1] = 2 * wt[2:nbin,1] ;          /* Number of obs for each
                                                   kernel evaluation */

   ih = 1 ; iseddvec = hgrid ;
   FORMAT /RD 4,0 ;
   DO WHILE ih <= ROWS(hgrid) ;
      IF ih/5 == FLOOR(ih/5) ; "WORKING ON H NUMBER " ih ; ENDIF ;
      h = hgrid[ih,1] ;

      /* Calculate the contribution due to the integrated square of the
         density estimate. */

      ifh2d = 0 ;
      h1= SQRT(2) * h ;
      sh1 = h1 * nbin / (rbctr - lbctr) ;
      arg = SEQA(0,1,nbin) / sh1 ;
      kernel = norm(arg) ;

      is = 0 ;              /* s in the paper. */
      DO WHILE is<= r - 1 ;
         isd = 0 ;          /* s' in the paper. */
         DO WHILE isd<= r - 1 ;
            coeff = ((-1)^(is+isd'))/((2^(2*is+2*isd+1/2))*(is!)*(isd!)) ;

            hp = 1 ;       /*  0th Hermite polynomial */
            hpn = arg ;    /*  1st Hermite polynomial */

            ip = 1 ;
            DO WHILE ip <= (is + isd) ;
               hp = arg .* hpn - (2*ip - 1) * hp ;   /* (2ip)th Hermite
                                                        polynomial. */
               hpn = arg .* hp - (2*ip) * hpn ;   /*  (2ip+1)th Hermite
                                                      polynomial. */
               ip = ip + 1 ;
            ENDO ;

            kern1 = kernel .* hp ;  /* the (2s+2s')th derivative of phi. */
            kern2 = kernel .* arg .* hpn ;
                                /* factor with (2s+2s'+1)th derivative. */

            hp = 1 ;       /*  0th Hermite polynomial */
            hpn = arg ;    /*  1st Hermite polynomial */

            ip = 1 ;
            DO WHILE ip <= (is + isd + 1) ;
               hp = arg .* hpn - (2*ip - 1) * hp ;   /* (2ip)th Hermite
                                                        polynomial. */
               hpn = arg .* hp - (2*ip) * hpn ;   /*  (2ip+1)th Hermite
                                                      polynomial. */
               ip = ip + 1 ;
            ENDO ;

            kern3 = kernel .* arg .* arg .* hp ;
                              /* factor with (2s+2s'+2)th derivative. */

            ifh2d = ifh2d + coeff * wt' * ( 2 * kern1 - 4 * kern2 + kern3 ) ;

            isd = isd + 1 ;
         ENDO ;
         is = is + 1 ;
      ENDO ;

      ifh2d = ifh2d / ((n^2)*(h^3)) ;

      /* Now compute the cross-product term. */

      ell = 1 ;
      cross = 0 ;
      DO WHILE ell <= ROWS(w) ;
         hell = SQRT( sig2[ell,1] + h^2 ) ;
         shell = hell * nbin / (rbctr - lbctr) ;
         arg = SEQA(1-nbin,1,2*nbin-1) / shell ;
         xkernel = norm(arg) ;

         is = 0 ;
         DO WHILE is <= r - 1 ;

            hp = 1 ;       /*  0th Hermite polynomial */
            hpn = arg ;    /*  1st Hermite polynomial */
            ip = 1 ;
            DO WHILE ip <= is ;
               hp = arg .* hpn - (2*ip - 1) * hp ;   /* (2ip)-th Hermite
                                                        polynomial. */
               hpn = arg .* hp - (2*ip) * hpn ;   /*  (2ip+1)-th Hermite
                                                         polynomial. */
               ip = ip + 1 ;
            ENDO ;

            xkern1 = xkernel .* hp ;  /* (2s)th derivative of phi. */
            xkern2 = xkernel .* arg .* hpn ;

         /* for factors involving the (2s+1)th derivative of phi. */

            hp = 1 ;       /*  0th Hermite polynomial */
            hpn = arg ;    /*  1st Hermite polynomial */
            ip = 1 ;
            DO WHILE ip <= is + 1 ;
               hp = arg .* hpn - (2*ip - 1) * hp ;   /* (2ip)-th Hermite
                                                        polynomial. */
               hpn = arg .* hp - (2*ip) * hpn ;   /*  (2ip+1)-th Hermite
                                                         polynomial. */
               ip = ip + 1 ;
            ENDO ;

            xkern3 = xkernel .* arg .* arg .* hp ;

            /* for factor involving the (2s+2)th derivative of phi. */

            curv1 = CONV(bincnts,xkern1,nbin,2*nbin-1) ;
            curv2 = CONV(bincnts,xkern2,nbin,2*nbin-1) ;
            curv3 = CONV(bincnts,xkern3,nbin,2*nbin-1) ;
            mulbin = FLOOR(nbin*(mu[ell,1]-lbctr) / (rbctr-lbctr)) ;
            term =2*is*(2*is-1)*h^(2*is-2)*curv1[mulbin,1]/hell^(2*is+1) ;
            term =term
                  -(4*is+1)*(2*is+1)*h^(2*is)*curv1[mulbin,1]/hell^(2*is+3) ;
            term = term
                  +(4*is+1)*h^(2*is)*curv2[mulbin,1]/hell^(2*is+3) ;
            term = term
                  +(2*is+1)*(2*is+3)*h^(2*is+2)*curv1[mulbin,1]/hell^(2*is+5);
            term = term
                  -(4*is+5)*h^(2*is+2)*curv2[mulbin,1]/hell^(2*is+5) ;
            term = term
                  +h^(2*is+2)*curv3[mulbin,1]/hell^(2*is+5) ;
            cross = cross + w[ell,1]*term ;
            is = is + 1 ;
         ENDO ;
         ell = ell + 1 ;
      ENDO ;

      cross = -2*cross / n ;

      iseddvec[ih,1] = ifh2d + cross  ;

      ih = ih + 1 ;
   ENDO ;
   RETP(iseddvec) ;

ENDP ;

/*************** END PROC MWisedd.g ***************/
