/* =========================== START PROC NMAMISE ======================== */
PROC NMAMISE(N,HGRID,MU,SIG2,W,KORD) ;
    /*  THIS CALCULATES ASY MISE USING NORMAL KERNEL OF ORDER KORD  */
    /*  FOR A NORMAL MIXTURE DENSITY  */
    /*  KORD = 2,4,6...  */
    /*  REQUIRES NORM.PRC
                 NMIDF2.G ALREADY LOADED  */
  LOCAL R,I,J,IK2,VAR,IXK,B2 ;

  R = KORD / 2 ;

           /*  CALCULATE INT(K^2)  */
  I = SEQA(0,1,R) ;
  J = I' ;
  IK2 = ((2 * I) + (2 * J))! ;
  IK2 = IK2 ./ EXP((3 * (I + J) + 1) .* LN(2)) ;
  IK2 = IK2 ./ ((I + J)!) ;
  IK2 = IK2 ./ (I!) ;
  IK2 = IK2 ./ (J!) ;
  IK2 = SUMC(SUMC(IK2)) / SQRT(PI) ;

  VAR = (IK2) ./ (N .* HGRID) ;

           /*  CALCULATE INT(X^KORD*K)   */
  IXK = (-1)^(R + 1) * (KORD!) / (2^R * (R!)) ;

  B2 = HGRID^(2*KORD) .* IXK .* IXK / (KORD!)^2 ;
  B2 = B2 .* NMIDF2(MU,SIG2,W,KORD) ;

  RETP((VAR+B2)~VAR~B2) ;
ENDP ;
/* ============================ END PROC NMAMISE ======================== */
