/* =========================== START PROC NMAMISEM ======================== */
PROC NMAMISEM(N,MU,SIG2,W,KORD) ;
    /*  THIS CALCULATES MIN'R AND MIN OF ASY MISE  */
    /*  USING NORMAL KERNEL OF ORDER KORD  */
    /*  FOR A NORMAL MIXTURE DENSITY  */
    /*  KORD = 2,4,6...  */
    /*  REQUIRES NORM.PRC
                 NMIDF2.G ALREADY LOADED  */
  LOCAL KORDT2,R,I,J,IK2,IXK,MINR,MIN ;

  KORDT2 = KORD * 2 ;
  R = KORD / 2 ;

           /*  CALCULATE INT(K^2)  */
  I = SEQA(0,1,R) ;
  J = I' ;
  IK2 = ((2 * I) + (2 * J))! ;
  IK2 = IK2 ./ EXP((3 * (I + J) + 1) .* LN(2)) ;
  IK2 = IK2 ./ ((I + J)!) ;
  IK2 = IK2 ./ (I!) ;
  IK2 = IK2 ./ (J!) ;
  IK2 = SUMC(SUMC(IK2)) / SQRT(PI) ;

           /*  CALCULATE INT(X^KORD*K)   */
  IXK = (-1)^(R + 1) * (KORD!) / (2^R * (R!)) ;

  MINR = IK2 * (KORD!)^2 ;
  MINR = MINR / (2 * KORD  * IXK * IXK * NMIDF2(MU,SIG2,W,KORD)) ;
  MINR = (MINR / N)^(1/(2 * KORD + 1)) ;

  MIN = (KORDT2)^(-KORDT2) * IK2^(KORDT2) * (IXK * IXK / (KORD!)^2) ;
  MIN = MIN * NMIDF2(MU,SIG2,W,KORD) * N^(-KORDT2) ;
  MIN = (KORDT2 + 1) * MIN^(1/(KORDT2 + 1)) ;

  RETP(MINR|MIN) ;
ENDP ;
/* ============================ END PROC NMAMISEM ======================== */
