/* =========================== START PROC NMBF ======================== */
PROC NMBF(MU,SIG2,W) ;
    /*  THIS CALCULATES BEST BANDWIDTH SELECTION CONSTANT  */
    /*  FOR A NORMAL MIXTURE DENSITY  */
    /*  REQUIRES NORM.PRC ALREADY LOADED  */
    /*  USES NMIDF2.G    */
    /*  ALGORITHM USES COR. 5.1.3 IN JUNE 29, 1990 NORMAL FACTS  */
  LOCAL I,MUT,MUTT,SIGT,SIGTT,MI,J1,J2,R,FACT,ARG,TOP,NDERIV,BOTTOM,BF ;

  TOP = 0 ;
  I = 1 ;
  DO WHILE I <= ROWS(MU) ;

    SIGT = SQRT((1 ./ SIG2) + (1 ./ SIG2') + (1 / SIG2[I,1])) ;
    MUT = (MU - MU')^2 ./ (SIG2 .* SIG2') ;
    MUT = MUT + (MU - MU[I,1])^2 ./ (SIG2 .* SIG2[I,1]) ;
    MUT = MUT + (MU' - MU[I,1])^2 ./ (SIG2' .* SIG2[I,1]) ;
    MUT = SQRT(MUT) ;

    SIGTT = 1 ./ SIGT ;
    MUTT = (MU ./ SIG2) + (MU' ./ SIG2') + (MU[I,1] / SIG2[I,1]) ;
    MUTT = MUTT ./ SIGT^2 ;

    MI = 0 ;
    J1 = 0 ;
    DO WHILE J1 <= 4 ;

      J2 = 0 ;
      DO WHILE J2 <= 4 ;

        R = (J1 + J2) / 2 ;
        IF FLOOR(R) == R ;
          FACT = (4! / (J1! * (4-J1)!)) * (4! / (J2! * (4-J2)!)) ;
            ARG = (MU - MUTT) ./ SQRT(SIG2) ;
          FACT = FACT .* NMHERMP(ARG,4-J1) ;
            ARG = (MU' - MUTT) ./ SQRT(SIG2') ;
          FACT = FACT .* NMHERMP(ARG,4-J2) ;
          FACT = FACT .* SIG2^((-4-J1-1)/2) ;
          FACT = FACT .* (SIG2')^((-4-J2-1)/2) ;
          FACT = FACT ./ SQRT(SIG2[I,1]) ;
          FACT = FACT .* SIGTT^(J1+J2) ;
          FACT = FACT .* (2 * R)! / (2^R * R!) ;
          MI = MI + FACT ;
        ENDIF ;

        J2 = J2 + 1 ;
      ENDO ;

      J1 = J1 + 1 ;
    ENDO ;


    FACT = PDFN(MUT ./ SIGT) ;
    FACT = FACT .* (FACT .> 10^(-300)) ;
    MI = (FACT ./ (SIGT .* SQRT(2 * PI))) .* MI ;

    TOP = TOP + W[I,1] * (W' * MI * W) ;

    I = I + 1 ;
  ENDO ;

    NDERIV = 2 ;
  BOTTOM = NMIDF2(MU,SIG2,W,NDERIV)^2 ;

  BF = 2 * SQRT(TOP/BOTTOM - 1) / 5 ;

  RETP(BF) ;
ENDP ;
/* ============================ END PROC NMBF ======================== */
