/* =========================== START PROC NMBLBIN ======================== */
PROC (1)=NMBLBIN(INCTS,INCEN,LEFT,RIGHT,NXGRID) ;
    /*  THIS DOES LINEAR BINNING OF PREVIOUSLY BINNED (BUT PERHAPS   */
    /*            SHIFTED) DATA.                                     */
    /*  INCTS ARE INCOMING COUNTS, INCEN IS INCOMING VECTOR OF BIN   */
    /*            CENTERS, NOT NECESSARILY EQUALLY SPACED            */
    /*  LEFT AND RIGHT ARE THE FIRST AND LAST GRID CENTERS           */
    /*  NXGRID IS THE NUMBER OF BINS                                 */

 LOCAL INCX,CENTS,FLAG,WTS,BINCTS ;

 INCX = (RIGHT - LEFT) / (NXGRID - 1) ;
 CENTS = SEQA(LEFT,INCX,NXGRID) ;

 FLAG = -(INCEN .<= LEFT) ;            /*  -1 AT INCENTERS BELOW RANGE  */
 FLAG = FLAG + (INCEN .>= RIGHT) ;     /*  +1 AT INCENTERS ABOVE RANGE  */

 WTS = (INCEN - LEFT) * (NXGRID - 1) / (RIGHT - LEFT) ;
                /*  TRANSFORM [LEFT,RIGHT] TO [0,NXGRID-1]
                        I.E. PUT "BIN CENTERS ON INTEGERS"  */
 WTS = WTS - FLOOR(WTS) ;     /*  DISTANCE TO NEXT LOWEST INTEGER  */
 WTS = WTS .* (ABS(FLAG) .<= .5) ;     /* 0 WEIGHT, EXCEPT IN "MIDRANGE" */

 BINCTS = COUNTWTS(INCEN,CENTS,WTS.*INCTS) ;
            /*  USE THE DISTANCE AS WEIGHT FOR NEXT GREATEST NEW BIN  */

 WTS = 1 - WTS ;              /*  DISTANCE TO NEXT GREATEST INTEGER  */
 WTS = WTS .* (ABS(FLAG) .<= .5) ;   /* 0 WEIGHT, EXCEPT IN "MIDRANGE" */
 BINCTS = BINCTS + REV(COUNTWTS(-INCEN,REV(-CENTS),WTS.*INCTS)) ;

 BINCTS[1,1] = BINCTS[1,1] + SUMC((FLAG .< -.5).*INCTS) ;
 BINCTS[NXGRID,1] = BINCTS[NXGRID,1] + SUMC((FLAG .> .5).*INCTS) ;

 RETP(BINCTS) ;
ENDP ;
/* ============================ END PROC NMBLBIN ======================== */
