/* =========================== START PROC NMCDFI ======================== */
PROC NMCDFI(P,MU,SIG2,W,XSTART,STARTF,RELACC) ;
    /*  THIS NUMERICALLY INVERTS A NORMAL MIXTURE CDF   */
    /*  IF ONLY ONE DENSITY, IT USES PHIINV.G  */
    /*  OTHERWISE DOES NEWTON'S METHOD (WITH RESTRICTED JUMP)  */
    /*  IF STARTF = 1, USES PSTART AS STARTING VALUE  */
    /*  OTHERWISE STARTS AT QUANTILE OF BIGGEST ONE  */
  LOCAL SIG,XNEW,IBIG,RELERR,MAXSTEP,ISTEP,XOLD,F,FP,STEP ;

  SIG = SQRT(SIG2) ;
  FORMAT /RD 12,8 ;

  IF ROWS(MU) == 1 ;     /*  REALLY ONLY ONE NORMAL HERE  */
    XNEW = MU + SIG * PHIINV(P) ;
  ELSE ;

    IF STARTF == 1 ;
      XNEW = XSTART ;
    ELSE ;
      IBIG = MAXINDC(W) ;
      XNEW = MU[IBIG,1] + SIG[IBIG,1] * PHIINV(P) ;
    ENDIF ;

    RELERR = 2 * RELACC ;
    MAXSTEP = MAXC(MAXC(ABS(MU - MU'))) ;  /* BIGGEST DIFFERENCE IN MU'S */
    MAXSTEP = MAXC(MAXSTEP|MAXC(SIG)) ;  /* MAX WITH BIGGEST SIGMA */
    ISTEP = 1 ;
    DO WHILE RELERR >= RELACC ;
      XOLD = XNEW ;

      F = NMCDF(XOLD,MU,SIG2,W) - P ;
      FP = NMF(XOLD,MU,SIG2,W) ;
      IF FP == 0 ;
        STEP = MAXSTEP/(1.1)^ISTEP ;
      ELSE ;
        STEP = F / FP ;
        IF STEP > 0 ;
          STEP = MINC(STEP|(MAXSTEP*(0.9)^ISTEP)) ;
        ELSE ;
          STEP = MAXC(STEP|(-MAXSTEP*(0.9)^ISTEP)) ;
        ENDIF ;
      ENDIF ;
      XNEW = XOLD - STEP ;

      RELERR = ABS(XNEW - XOLD) / MAXC(ABS(XNEW)|RELACC) ;
      "X = " XNEW "        RELERR = " RELERR ;
      ISTEP = ISTEP + 1 ;
    ENDO ;

  ENDIF ;

  RETP(XNEW) ;
ENDP ;
/* ============================ END PROC NMCDFI ======================== */
