/* =========================== START PROC NMCRITS ======================== */
PROC NMCRITS(DATA,LEFT,RIGHT,NXGRID,NMODE,HACC) ;
    /*  THIS FINDS A CRITICALLY SMOOTHED,  */
    /*  BETWEEN NMODE AND NMODE+1 MODES, DENSITY ESTIMATE  */
    /*  FOR THE N(0,1) KERNEL  */
    /*  USING A BINNED IMPLEMENTATION  */
    /*  ALGORITHM IS A BISECTION SEARCH,  */
    /*  STARTING AT H_OVERSMOOTHED  */
    /*  UNTIL BANDWIDTHS H0 AND H1 ARE FOUND ON OPPOSITE SIDES OF HCRIT  */
    /*  WHERE H1/H0 < HACC  */
    /*  RETURN IS (BEST GUESS ABOUT HCRIT)|(CRIT SMOOTHED EST)  */

  LOCAL NOBS,KORD,BINCTS,HNEW,HOLD,FHAT,NM,HBIG,HSMALL ;

  NOBS = ROWS(DATA) ;
  KORD = 2 ;

  ? ; "BINNING" ;
  BINCTS = NMLBIN(DATA,LEFT,RIGHT,NXGRID) ;

  HNEW = STDC(DATA) * 3 / (70 * SQRT(PI) * NOBS)^(1/5) ;

  FHAT = NMFHB(BINCTS,LEFT,RIGHT,HNEW,KORD) ;
  NM = NMMCT(FHAT) ;

  ? ;
                /*  GET HOLD AND HNEW TO BRACKET HCRIT  */
  IF NM > NMODE ;           /*  IF H TO LEFT OF HCRIT  */
    DO WHILE NM > NMODE ;   /*  ITERATE UNTIL HAVE H TO RIGHT OF HCRIT  */

      " FIRST ROUND STEPPING UP, H = " HNEW ;
      HOLD = HNEW ;
      HNEW = 2 * HOLD ;
      FHAT = NMFHB(BINCTS,LEFT,RIGHT,HNEW,KORD) ;
      NM = NMMCT(FHAT) ;

    ENDO ;
  ELSE ;                      /*  IF H TO RIGHT OF HCRIT  */
    DO WHILE NM <= NMODE ;   /*  ITERATE UNTIL HAVE H TO LEFT OF HCRIT  */

      " FIRST ROUND STEPPING DOWN, H = " HNEW ;
      HOLD = HNEW ;
      HNEW = HOLD / 2 ;
      FHAT = NMFHB(BINCTS,LEFT,RIGHT,HNEW,KORD) ;
      NM = NMMCT(FHAT) ;

    ENDO ;

  ENDIF ;


  ? ;
                  /*   NOW CLOSE IN ON HCRIT  */
  HBIG = MAXC(HOLD|HNEW) ;
  HSMALL = MINC(HOLD|HNEW) ;
  DO WHILE (HBIG / HSMALL) > 1 + HACC ;  /*  ITERATE TO DESIRED ACCURACY  */

      "   IMPROVING, ERROR = " ((HBIG / HSMALL) - 1) ;
    HNEW = SQRT(HBIG * HSMALL) ;   /*  GEOMETRIC MEAN  */
    FHAT = NMFHB(BINCTS,LEFT,RIGHT,HNEW,KORD) ;
    NM = NMMCT(FHAT) ;

    IF NM > NMODE ;           /*  IF HNEW TO LEFT OF HCRIT  */
      HSMALL = HNEW ;
    ELSE ;
      HBIG = HNEW ;
    ENDIF ;

  ENDO ;
  ? ;


  RETP(HNEW|FHAT) ;
ENDP ;
/* ============================ END PROC NMCRITS ======================== */

