/* =========================== START PROC NMCTS ======================== */
PROC NMCTS(X,V,EPFLAG) ;
    /*  THIS IS AN ENHANCEMENT OF USUAL GAUSS PROC COUNTS  */
    /*  V'S GIVE BIN ENDPOINTS, MUST BE SORTED  */
    /*  RETURNS (NV+1)-VECTOR CONTAINING COUNTS IN EACH BIN  */
    /*  FIRST COUNT FOR X VALUES LYING BELOW FIRST V  */
    /*  LAST COUNT FOR X VALUES LYING ABOVE LAST V  */
    /*  EPFLAG > 0 MEANS BIN INCLUDES RIGHT ENDPOINT (SAME AS IN COUNTS) */
    /*         < 0 MEANS BIN INCLUDES LEFT ENDPOINT  */

  LOCAL NX,CTS ;

  NX = ROWS(X) ;

  IF EPFLAG > 0 ;
    CTS = COUNTS(X,V) ;
    CTS = CTS|(NX - SUMC(CTS)) ;
  ELSE ;
    CTS = COUNTS(-X,REV(-V)) ;
    CTS = CTS|(NX - SUMC(CTS)) ;
    CTS = REV(CTS) ;
  ENDIF ;

  RETP(CTS) ;
ENDP ;
/* ============================ END PROC NMCTS ======================== */
