/* =========================== START PROC NMCV ======================== */
PROC NMCV(DATA,HGRID) ;
   /*  DIRECT MATRIX CALCULATION OF LEAST SQUARES CROSS-VALIDATION  */
   /*  DATA ARE A COLUMN VECTOR OF X'S  */
   /*  CAUTION: THIS USES n BY n MATRICES,              */
   /*          SO CAN EASILY FILL WORKSPACE FOR n TOO LARGE  */
   /*  ASSUMES THE STANDARD NORMAL KERNEL  */
   /*  OUTPUT IS A VECTOR OF VALUES OF CV       */

 LOCAL N,NH,IK2,R2,VCV,IH,H,MDIF,DDIF,CV,TERM2 ;

 N = ROWS(DATA) ;
 NH = ROWS(HGRID) ;

 IK2 = 1 / (2 * SQRT(PI)) ;     /*  INTEGRAL OF K SQUARED  */
 R2 = SQRT(2) ;

 VCV = ZEROS(NH,1) ;
 IH = 1 ;
 DO WHILE IH <= NH ;
   "WORKING ON H NUMBER" IH ;
       /*  CAUTION: THIS SCREEN WRITE CAN SLOW DOWN PROGRAMS,
               BE CAREFUL ABOUT INCLUDING THIS KIND OF THING  */
   H = HGRID[IH] ;

   MDIF = DATA - DATA' ;          /*  MATRIX OF DIFFERENCES  */
   MDIF = MDIF / H ;

   CV = PDFN(MDIF / R2) / R2 ;    /*  CONVOLUTION OF GAUSSIAN KERNELS  */
   CV = SUMC(SUMC(CV)) ;      /*  DOUBLE SUMMATION  */
   CV = CV / (N * N * H) ;


   TERM2 = PDFN(MDIF) ;
   TERM2 = DIAGRV(TERM2,ZEROS(N,1)) ;    /*  REMOVE DIAGONAL  */
   TERM2 = SUMC(SUMC(TERM2)) ;      /*  DOUBLE SUMMATION  */
   CV = CV - 2 * TERM2 / (N * (N - 1) * H) ;

   VCV[IH] = CV ;

   IH = IH + 1 ;
 ENDO ;


 RETP(VCV) ;
ENDP ;
/* ============================ END PROC NMCV ======================== */
