/* =========================== START PROC NMDF ======================== */
PROC NMDF(XGRID,MU,SIG2,W,NDERIV) ;
    /*  THIS CALCULATES NDERIV-TH DERIVATIVE OF A NORMAL MIXTURE DENSITY  */
    /*  NDERIV = 0,1,2...  */
    /*  REQUIRES NORM.PRC ALREADY LOADED  */
  LOCAL SIG,ARG,H,HP,HPP,I,DPHI,FACTOR ;

  SIG = SQRT(SIG2) ;
  ARG = (XGRID - MU') ./ SIG' ;

                /*  GENERATE HERMITE POLYNOMIALS  */
  HPP = ONES(ROWS(XGRID),1) ;
  IF NDERIV == 0 ;
    H = HPP ;         /*  0TH HERMITE POLY  */
  ELSE;
    HP = ARG ;
    IF NDERIV == 1 ;
      H = HP ;        /*  1ST HERMITE POLY  */
    ELSE ;
      I = 2 ;
      DO WHILE I <= NDERIV ;
        H = ARG .* HP - (I - 1) * HPP ;   /*  ITH HERMITE POLY  */
        HPP = HP ;
        HP = H ;
        I = I + 1 ;
      ENDO ;
    ENDIF ;
  ENDIF ;
  HP = 0 ; HPP = 0 ;        /*  TO SAVE SPACE  */

  DPHI = (-1)^NDERIV .* H .* NORM(ARG) ;

  FACTOR = W ./ SIG^(NDERIV + 1) ;

  RETP(DPHI * FACTOR) ;
ENDP ;
/* ============================ END PROC NMDF ======================== */
