/* =========================== START PROC NMDFH ======================== */
PROC NMDFH(XGRID,DATA,H,DERIV) ;
    /*  THIS DOES AN EXACT CALCULATION OF  */
    /*  A KERNEL DENSITY DERIVATIVE ESTIMATE   */
    /*  FOR GAUSSIAN KERNEL ONLY  */
  LOCAL NOBS,NXGRID,IOBS,FHAT,ARG,HP,HPRM2,HPRM1,R,M1TOP ;

  NOBS = ROWS(DATA) ;
  NXGRID = ROWS(XGRID) ;

  IOBS = 1 ;
  FHAT = ZEROS(NXGRID,1) ;
    DO WHILE IOBS <= NOBS ;
      IF FLOOR(IOBS/10) == IOBS/10 ; "    WORKING ON OBS " IOBS ; ENDIF ;
      ARG = XGRID - DATA[IOBS,1] ;
      ARG = ARG / H ;

      IF DERIV == 0 ;
        HP = ONES(ROWS(ARG),COLS(ARG)) ;          /*  0TH HERMITE POLY  */
      ELSEIF DERIV == 1 ;
        HP = ARG ;                                /*  1ST HERMITE POLY  */
      ELSE ;         /*  NEED TO ITERATE  */
        HPRM2 = ONES(ROWS(ARG),COLS(ARG)) ;       /*  0TH HERMITE POLY  */
        HPRM1 = ARG ;                             /*  1ST HERMITE POLY  */
        R = 2 ;
        DO WHILE R <= DERIV ;
          HP = ARG .* HPRM1 - (R - 1) * HPRM2 ;    /* RTH HERNITE POLY  */
          HPRM2 = HPRM1 ;
          HPRM1 = HP ;
          R = R + 1 ;
        ENDO ;
      ENDIF ;

      FHAT = FHAT + HP .* NORM(ARG) ;
      IOBS = IOBS + 1 ;
    ENDO ;

    IF FLOOR(DERIV / 2) == (DERIV / 2) ;
      M1TOP = 1 ;
    ELSE ;
      M1TOP = -1 ;
    ENDIF ;

  FHAT = M1TOP * FHAT / (NOBS * H^(DERIV+1)) ;

  RETP(FHAT) ;
ENDP ;
/* ============================ END PROC NMDFH ======================== */
