/* =========================== START PROC NMDFHB ======================== */
PROC NMDFHB(BINCTS,A,B,H,DERIV) ;
    /*  THIS DOES A BINNED CALCULATION OF  */
    /*  DERIVATIVES OF A KERNEL DENSITY ESTIMATE   */
    /*  FOR THE GAUSSIAN KERNEL ONLY  */
  LOCAL NOBS,NXGRID,SH,ARG,HP,HPRM1,HPRM2,R,M,FHAT,M1TOP ;

  NOBS = SUMC(BINCTS) ;
  NXGRID = ROWS(BINCTS) ;

  SH = H * (NXGRID / (B - A)) ;

  ARG = SEQA(1-NXGRID,1,2*NXGRID-1) / SH ;

  IF DERIV == 0 ;
    HP = ONES(ROWS(ARG),COLS(ARG)) ;          /*  0TH HERMITE POLY  */
  ELSEIF DERIV == 1 ;
    HP = ARG ;                                /*  1ST HERMITE POLY  */
  ELSE ;         /*  NEED TO ITERATE  */
    HPRM2 = ONES(ROWS(ARG),COLS(ARG)) ;       /*  0TH HERMITE POLY  */
    HPRM1 = ARG ;                             /*  1ST HERMITE POLY  */
    R = 2 ;
    DO WHILE R <= DERIV ;
      HP = ARG .* HPRM1 - (R - 1) * HPRM2 ;    /* RTH HERNITE POLY  */
      HPRM2 = HPRM1 ;
      HPRM1 = HP ;
      R = R + 1 ;
    ENDO ;
  ENDIF ;

  M = HP .* NORM(ARG) ;

  FHAT = CONV(BINCTS,M,NXGRID,2*NXGRID-1) ;

    IF FLOOR(DERIV / 2) == (DERIV / 2) ;
      M1TOP = 1 ;
    ELSE ;
      M1TOP = -1 ;
    ENDIF ;

  FHAT = M1TOP * FHAT / (NOBS * H^(DERIV+1)) ;

  RETP(FHAT) ;
ENDP ;
/* ============================ END PROC NMDFHB ======================== */
