/* =========================== START PROC NMDMISE ======================== */
PROC NMDMISE(N,HGRID,MU,SIG2,W,KORD) ;
    /*  THIS CALCULATES MISE AND FIRST TWO DERIVATIVES  */
    /*  USING NORMAL KERNEL OF ORDER KORD  */
    /*  FOR A NORMAL MIXTURE DENSITY  */
    /*  KORD = 2,4,6...  */
    /*  REQUIRES NORM.PRC ALREADY LOADED  */
  LOCAL R,I,J,IK2,CS,IH,H,SLL,SLLH,SLLHH,M0,M1,M2,ARG,NARG,HP,HPN,HPNN,
          HPNNN,HPNNNN,U0,U1,U2,TERM,IS,S4,CROSS,IF2,VM0,VM1,VM2 ;

  R = KORD / 2 ;

           /*  CALCULATE INT(K^2)  */
  I = SEQA(0,1,R) ;
  J = I' ;
  IK2 = ((2 * I) + (2 * J))! ;
  IK2 = IK2 ./ EXP((3 * (I + J) + 1) .* LN(2)) ;
  IK2 = IK2 ./ ((I + J)!) ;
  IK2 = IK2 ./ (I!) ;
  IK2 = IK2 ./ (J!) ;
  IK2 = SUMC(SUMC(IK2)) / SQRT(PI) ;

  CS = SEQM(1,-.5,R) ./ SEQA(0,1,R)! ;

  IH = 1 ;
  FORMAT /RD 4,0 ;
  DO WHILE IH <= ROWS(HGRID) ;
    IF IH/10 == FLOOR(IH/10) ; "WORKING ON H NUMBER " IH ; ENDIF ;
    H = HGRID[IH,1] ;

            /*  USEFUL MATRICES  */
    SLL = SQRT(SIG2' + SIG2) ;
    SLLH = SQRT(H^2 + SIG2' + SIG2) ;
    SLLHH = SQRT(2*H^2 + SIG2' + SIG2) ;

             /*  CALCULATE DOMINANT PART OF VARIANCE  */
    M0 = IK2 / (N * H) ;
    M1 = -IK2 / (N * H^2) ;
    M2 = 2 * IK2 / (N * H^3) ;

             /*  CALCULATE INNER DOUBLE SUMS   */
    ARG = (MU' - MU) ./ SLLHH ;
    NARG = NORM(ARG) ;
    HP = ONES(ROWS(MU),ROWS(MU)) ;            /*  0TH HERMITE POLY  */
    HPN = ARG ;                               /*  1ST HERMITE POLY  */
    HPNN = ARG^2 - 1 ;                        /*  2ND HERMITE POLY  */
    HPNNN = ARG^3 - 3 * ARG ;                 /*  3RD HERMITE POLY  */
    HPNNNN = ARG^4 - 6 * ARG^2 + 3 ;          /*  4TH HERMITE POLY  */
      TERM = HP .* NARG ./ SLLHH ;
    U0 = W' * TERM * W ;
      TERM = 2 * HPNN .* NARG .* H ./ SLLHH^3 ;
    U1 = W' * TERM * W ;
      TERM = 2 * HPNN .* NARG ./ SLLHH^3 ;
      TERM = TERM + 4 * HPNNNN .* NARG .* H^2 ./ SLLHH^5 ;
    U2 = W' * TERM * W ;
    IS = 1 ;
    DO WHILE IS <= (2 * R - 2) ;
      HP = HPNN ;
      HPN = HPNNN ;
      HPNN = HPNNNN ;
      HPNNN = ARG .* HPNN - (2*IS + 2) * HPN ;
                              /*  (2*IS+3)-TH HERMITE POLY  */
      HPNNNN = ARG .* HPNNN - (2*IS + 3) * HPNN ;
                              /*  (2*IS+4)-TH HERMITE POLY  */
        TERM = HP .* NARG .* H^(2*IS) ./ SLLHH^(2*IS+1) ;
      U0 = U0~(W' * TERM * W) ;
        TERM = 2 * IS * HP .* NARG .* H^(2*IS-1) ./ SLLHH^(2*IS+1) ;
        TERM = TERM + 2 * HPNN .* NARG .* H^(2*IS+1) ./ SLLHH^(2*IS+3) ;
      U1 = U1~(W' * TERM * W) ;
        TERM = 2*IS * (2*IS-1) .* HP .* NARG .* H^(2*IS-2)./ SLLHH^(2*IS+1) ;
        TERM = TERM + 2*(4*IS+1) .* HPNN .* NARG .*H^(2*IS)./SLLHH^(2*IS+3) ;
        TERM = TERM + 4 .* HPNNNN .* NARG .* H^(2*IS+2) ./ SLLHH^(2*IS+5) ;
      U2 = U2~(W' * TERM * W) ;
     IS = IS + 1 ;
    ENDO ;

             /*  CALCULATE OUTER DOUBLE SUMS   */
    U0 = U0 .* ONES(R,1) ;
    U0 = ROTATER(U0,SEQA(0,-1,R)) ;
    U0 = U0[.,1:R] ;
    M0 = M0 + ((N - 1) / N) * CS' * U0 * CS ;
    U1 = U1 .* ONES(R,1) ;
    U1 = ROTATER(U1,SEQA(0,-1,R)) ;
    U1 = U1[.,1:R] ;
    M1 = M1 + ((N - 1) / N) * CS' * U1 * CS ;
    U2 = U2 .* ONES(R,1) ;
    U2 = ROTATER(U2,SEQA(0,-1,R)) ;
    U2 = U2[.,1:R] ;
    M2 = M2 + ((N - 1) / N) * CS' * U2 * CS ;

             /*  CALCULATE CROSS TERM IN BIAS  */
    ARG = (MU' - MU) ./ SLLH ;
    NARG = NORM(ARG) ;
    HP = ONES(ROWS(MU),ROWS(MU)) ;            /*  0TH HERMITE POLY  */
    HPN = ARG ;                               /*  1ST HERMITE POLY  */
    HPNN = ARG^2 - 1 ;                        /*  2ND HERMITE POLY  */
    HPNNN = ARG^3 - 3 * ARG ;                 /*  3RD HERMITE POLY  */
    HPNNNN = ARG^4 - 6 * ARG^2 + 3 ;          /*  4TH HERMITE POLY  */
      TERM = HP .* NARG ./ SLLH ;
    U0 = W' * TERM * W ;
      TERM = HPNN .* NARG .* H ./ SLLH^3 ;
    U1 = W' * TERM * W ;
      TERM = HPNN .* NARG ./ SLLH^3 ;
      TERM = TERM + HPNNNN .* NARG .* H^2 ./ SLLH^5 ;
    U2 = W' * TERM * W ;
    IS = 1 ;
    DO WHILE IS <= (R - 1) ;
      HP = HPNN ;
      HPN = HPNNN ;
      HPNN = HPNNNN ;
      HPNNN = ARG .* HPNN - (2*IS + 2) * HPN ;
                              /*  (2*IS+3)-TH HERMITE POLY  */
      HPNNNN = ARG .* HPNNN - (2*IS + 3) * HPNN ;
                              /*  (2*IS+4)-TH HERMITE POLY  */
        TERM = HP .* NARG .* H^(2*IS) ./ SLLH^(2*IS+1) ;
      U0 = U0|(W' * TERM * W) ;
        TERM = 2 * IS * HP .* NARG .* H^(2*IS-1) ./ SLLH^(2*IS+1) ;
        TERM = TERM + HPNN .* NARG .* H^(2*IS+1) ./ SLLH^(2*IS+3) ;
      U1 = U1|(W' * TERM * W) ;
        TERM = 2*IS * (2*IS-1) .* HP .* NARG .* H^(2*IS-2)./ SLLH^(2*IS+1) ;
        TERM = TERM + (4*IS+1) .* HPNN .* NARG .*H^(2*IS)./SLLH^(2*IS+3) ;
        TERM = TERM + HPNNNN .* NARG .* H^(2*IS+2) ./ SLLH^(2*IS+5) ;
      U2 = U2|(W' * TERM * W) ;
      IS = IS + 1 ;
    ENDO ;
    M0 = M0 - 2 * CS' * U0 ;
    M1 = M1 - 2 * CS' * U1 ;
    M2 = M2 - 2 * CS' * U2 ;

             /*  CALCULATE INT(F^2) TERM IN BIAS  */
    ARG = (MU' - MU) ./ SLL ;
    NARG = NORM(ARG) ;
    M0 = M0 + W' * (NARG ./ SLL) * W ;

    IF IH == 1 ;
      VM0 = M0 ;
      VM1 = M1 ;
      VM2 = M2 ;
    ELSE ;
      VM0 = VM0|M0 ;
      VM1 = VM1|M1 ;
      VM2 = VM2|M2 ;
    ENDIF ;
    IH = IH + 1 ;
  ENDO ;

  RETP(VM0~VM1~VM2) ;
ENDP ;
/* ============================ END PROC NMDMISE ======================== */
