/* =========================== START PROC NMEF ======================== */
PROC NMEF(XGRID,H,KORD,MU,SIG2,W) ;
    /*  THIS CALCULATES EXPECTED VALUE OF A KERNEL ESTIMATE  */
    /*  USING A GAUSSIAN HIGHER ORDER KERNEL  */
    /*  FOR A NORMAL MIXTURE DENSITY  */
    /*  THE BANDWIDTH H AND THE KERNEL ORDER MUST BE SCALARS  */
    /*  REQUIRES NORM.PRC ALREADY LOADED  */
  LOCAL R,SLH,CS,ARG,NARG,HP,HPN,M,IS ;

  R = KORD / 2 ;
  SLH = SQRT(1 + (SIG2/H^2)) ;
  CS = SEQM(1,-.5,R) ./ SEQA(0,1,R)! ;


           /*  CALCULATE CROSS TERM IN BIAS  */
  ARG = (XGRID' - MU) ./ (H * SLH) ;
  NARG = NORM(ARG) ;
  HP = ONES(ROWS(ARG),COLS(ARG)) ;       /*  0TH HERMITE POLY  */
  HPN = ARG ;                         /*  1ST HERMITE POLY  */
  M = W' * (HP .* NARG ./ SLH) ;
  IS = 1 ;
  DO WHILE IS <= (R - 1) ;
    HP = ARG .* HPN - (2*IS - 1) * HP ;   /* (2*IS)-TH HERMITE POLY  */
    HPN = ARG .* HP - (2*IS) * HPN ;   /*  (2*IS+1)-TH HERMITE POLY  */
    M = M|(W' * (HP .* NARG ./ SLH^(2 * IS + 1))) ;
    IS = IS + 1 ;
  ENDO ;
  M = CS' * M ;         /*  SUM ON S   */

  M = M / H ;

  RETP(M') ;
ENDP ;
/* ============================ END PROC NMEF ======================== */
