/* =========================== START PROC NMF2 ======================== */
PROC NMF2(XGRID,MU,SIG2,W) ;
    /*  THIS CALCULATES A NORMAL MIXTURE DENSITY  */
    /*  MODIFIES NMF, BY ALLOWING BIGGER XGRID FOR COMPLEX DENSITIES  */
    /*  ALSO ALLOWS XGRID TO BE A MATRIX  */
    /*  REQUIRES NORM.PRC ALREADY LOADED  */
  LOCAL NW,IW,SIG,ARG,F ;

  NW = ROWS(W) ;

  IW = 1 ;
  F = ZEROS(ROWS(XGRID),COLS(XGRID)) ;
  DO WHILE IW <= NW ;
    SIG = SQRT(SIG2[IW,1]) ;
    ARG = (XGRID - MU[IW,1]) ./ SIG ;

    F = F + (NORM(ARG) * (W[IW,1] ./ SIG)) ;
    IW = IW + 1 ;
  ENDO ;

  RETP(F) ;
ENDP ;
/* ============================ END PROC NMF2 ======================== */
