/* =========================== START PROC NMFH ======================== */
PROC NMFH(XGRID,DATA,H,KORD) ;
    /*  THIS DOES AN EXACT CALCULATION OF A KERNEL DENSITY ESTIMATE   */
    /*  NBLOCKS NEEDS TO EVENLY DIVIDE NOBS, NUMBER OF ELEMENTS IN DATA  */
  LOCAL NOBS,NXGRID,INCROWS,R,CS,IOBS,FHAT,ARG,NARG,HP,HPN,M,IS ;

  NOBS = ROWS(DATA) ;
  NXGRID = ROWS(XGRID) ;

  R = KORD / 2 ;
  CS = SEQM(1,-.5,R) ./ SEQA(0,1,R)! ;

  IOBS = 1 ;
  FHAT = ZEROS(NXGRID,1) ;
    DO WHILE IOBS <= NOBS ;
      IF FLOOR(IOBS/10) == IOBS/10 ; "    WORKING ON OBS " IOBS ; ENDIF ;
      ARG = XGRID - DATA[IOBS,1] ;
      ARG = ARG / H ;

      NARG = NORM(ARG) ;
      HP = ONES(ROWS(ARG),COLS(ARG)) ;       /*  0TH HERMITE POLY  */
      HPN = ARG ;                         /*  1ST HERMITE POLY  */
      M = HP .* NARG ;
      IS = 1 ;
      DO WHILE IS <= (R - 1) ;
        HP = ARG .* HPN - (2*IS - 1) * HP ;   /* (2*IS)-TH HERMITE POLY  */
        HPN = ARG .* HP - (2*IS) * HPN ;   /*  (2*IS+1)-TH HERMITE POLY  */
        M = M~(HP .* NARG) ;
        IS = IS + 1 ;
      ENDO ;
      M = M * CS ;         /*  SUM ON S   */

      FHAT = FHAT + M ;
      IOBS = IOBS + 1 ;
    ENDO ;
  FHAT = FHAT / (NOBS * H) ;

  RETP(FHAT) ;
ENDP ;
/* ============================ END PROC NMFH ======================== */
