/* =========================== START PROC NMFHB ======================== */
PROC NMFHB(BINCTS,A,B,H,KORD) ;
    /*  THIS DOES A BINNED CALCULATION OF A KERNEL DENSITY ESTIMATE   */
  LOCAL NOBS,NXGRID,SH,R,CS,FHAT,ARG,NARG,HP,HPN,M,IS ;


  NOBS = SUMC(BINCTS) ;
  NXGRID = ROWS(BINCTS) ;

  SH = H * (NXGRID / (B - A)) ;
  R = KORD / 2 ;
  CS = SEQM(1,-.5,R) ./ SEQA(0,1,R)! ;

  ARG = SEQA(1-NXGRID,1,2*NXGRID-1) / SH ;

  NARG = NORM(ARG) ;
  HP = ONES(ROWS(ARG),COLS(ARG)) ;       /*  0TH HERMITE POLY  */
  HPN = ARG ;                         /*  1ST HERMITE POLY  */
  M = HP .* NARG ;
  IS = 1 ;
  DO WHILE IS <= (R - 1) ;
    HP = ARG .* HPN - (2*IS - 1) * HP ;   /* (2*IS)-TH HERMITE POLY  */
    HPN = ARG .* HP - (2*IS) * HPN ;   /*  (2*IS+1)-TH HERMITE POLY  */
    M = M~(HP .* NARG) ;
    IS = IS + 1 ;
  ENDO ;
  M = M * CS ;         /*  SUM ON S   */

  FHAT = CONV(BINCTS,M,NXGRID,2*NXGRID-1) ;
  FHAT = FHAT / (NOBS * H) ;

  RETP(FHAT) ;
ENDP ;
/* ============================ END PROC NMFHB ======================== */
