/* =========================== START PROC NMGPIBW ======================== */
PROC (1)=NMGPIBW(DIFWTS,A,B,PILF,SD) ;
    /*  THIS CALCULATES GENERAL DIRECT PLUG-INS   */
    /*  FOR A GAUSSIAN KERNEL FUNCTION   */
    /*  PILF SAYS WHAT TYPE OF PILOT TO USE, 0 = N(0,SD) REFERENCE  */
    /*  -K = K-TIMES ESTIMATED, DIAGONALS OUT   */
    /*  +K = K-TIMES ESTIMATED, DIAGONALS IN   */
    /*  SD IS A SCALE ESTIMATE, ADJUSTED SO IT = 1 AT N(0,1)   */

  LOCAL RK,DERIV,KORD,NOBS,NI,DIAGF,H ;

  RK = 1 / (2 * SQRT(PI)) ;
  DERIV = 2 ;   /*  PARAMETERS FOR DOUBLE SUM   */
  KORD = 2 ;
  NOBS = SQRT(SUMC(SUMC(DIFWTS))) ;

  NI = ABS(PILF) ;
  IF PILF >= 0 ;
    DIAGF = 1 ;
  ELSE ;
    DIAGF = 0 ;
  ENDIF ;

  H = NMI2ABW(DIFWTS,A,B,NI,DERIV,KORD,DIAGF,SD) ;
  H = (RK / (H * NOBS))^(1/5) ;


  RETP(H) ;
ENDP;
/* ======================== END PROCEDURE NMGPIBW ======================== */
