/* =========================== START PROC NMHERMP ======================== */
PROC NMHERMP(X,DEG) ;
    /*  THIS CALCULATES THE HERMITE POLYNOMIAL OF DEGREE DEG  */
    /*  AT THE MATRIX ARGUMENT X  */
  LOCAL HPP,HP,H,I ;

  HPP = ONES(ROWS(X),COLS(X)) ;
  IF DEG == 0 ;
    H = HPP ;         /*  0TH HERMITE POLY  */
  ELSE;
    HP = X ;
    IF DEG == 1 ;
      H = HP ;        /*  1ST HERMITE POLY  */
    ELSE ;
      I = 2 ;
      DO WHILE I <= DEG ;
        H = X .* HP - (I - 1) * HPP ;   /*  ITH HERMITE POLY  */
        HPP = HP ;
        HP = H ;
        I = I + 1 ;
      ENDO ;
    ENDIF ;
  ENDIF ;

  RETP(H) ;
ENDP ;
/* ============================ END PROC NMHERMP ======================== */
