/* =========================== START PROC NMHJBW ======================== */
PROC (1)=NMHJBW(DIFWTS,A,B,HCUP,J1,J2) ;
    /*  THIS CALCULATES THE HALL JOHNSTONE ISE BASED SELECTOR   */
    /*  FOR A GAUSSIAN KERNEL FUNCTION   */
    /*  HCUP IS A PILOT BANDWIDTH WHICH SHOULD HAVE RATE OF   */
    /*                   CONVERGENCE FASTER THAN  N^(-1/10)       */
    /*  J1 AND J2 ARE EITHER ESTIMATED                          */
    /*        (USE NMI2ABW(DIFWTS,A,B,NI,NDERIV,KORD,DIAGF,SD) FOR THIS)  */
    /*     OR THEORETICAL VALUES                                */
    /*        (USE NMIDF2(MU,SIG2,W,NDERIV) FOR THIS)  */
    /*     FOR THE INTEGRATED SQUARED FIRST AND SECOND DERIVATIVES  */

  LOCAL KORD,NOBS,K1,K2,K3,IFA,BHAT,HHAT ;

  KORD = 2 ;

  NOBS = SQRT(SUMC(SUMC(DIFWTS))) ;

  K1 = 1 / (2 * SQRT(PI)) ;            /*  INT(K^2)  */
  K2 = 1 ;                             /*  INT(X^2 K)^2  */
  K3 = (1 / 3) * 3  ;                  /*  1/3 INT(X^4 K)  */

  IFA = HCUP^2 *NMI2HBW(DIFWTS,A,B,SQRT(2)*HCUP,1,KORD,1) ;
                             /*  1 FOR FIRST DERIV, AND 1 FOR DIAGS IN  */

  BHAT = HCUP * (2 * K1 / (NOBS * HCUP^3)  +  3 * HCUP^2 * K2 * J2) ;

  HHAT = 2 * IFA  +  K3 * HCUP^4 * J2  -  2 * SQRT(K2) * HCUP^2 * J1 ;
  HHAT = HCUP + HHAT / BHAT ;

  RETP(HHAT) ;
ENDP;
/* ======================== END PROCEDURE NMHJBW ======================== */
