/* =========================== START PROC NMI2ABW ======================== */
PROC NMI2ABW(DIFWTS,A,B,NI,DERIV,KORD,DIAGF,SD) ;
    /*  THIS DOES A BINNED CALCULATION OF A KERNEL ESTIMATE   */
    /*  OF THE INTEGRATED SQUARED DENSITY DERIVATIVE   */
    /*  VERY SIMILAR TO NMI2HBW, EXCEPT BANDWIDTH IS AUTOMATIC   */
    /*  THE KERNEL IS  K  AS OPPOSED TO  K*K (WHICH COMES FROM   */
    /*  INTEGRATING ACTUALLY KERNEL DENSITY ESTIMATOR,  FOR K*K   */
    /*  PLUG IN BANDWIDTH TIMES SQRT(2))  */
    /*  NI = STEP NUMBER WHERE N(0,1) REFERENCE BANDWIDTH IS USED   */
    /*  NI = 0, RETURNS JUST REFERENCE VALUE,  */
    /*  NI = 1, DOES ONE ESTIMATION STEP  */
    /*  THIS VERSION ONLY WORKS FOR KORD = 2   */
    /*  IF DIAGF = 0, DIAGONALS ARE LEFT OUT, OTHERWISE NOT   */
    /*  THIS MODIFIES NMI2HB, BY USING   */
    /*  DIFWTS, THE WEIGHTS FOR PAIRWISE DIFFERENCES, FROM NMDW.G   */
    /*  SD IS AN ESTIMATE OF SCALE, IN UNITS OF STANDARD DEVIATION   */

  LOCAL NOBS,J,RF,VRF,ND,RFP,I,H,IDF2 ;

  NOBS = SQRT(SUMC(SUMC(DIFWTS))) ;

  IF DIAGF == 0 ;
    J = 0 ;
    DO WHILE J <= NI ;
      RF = (2 * J)! / (2^J * J!) ;     /*  ODD FACTORIAL(2*J)  */
      RF = RF / (SQRT(PI) * 2^(J + 1)) ;
      RF = RF / SD^(2*J + 1) ;     /*  N(0,SD^2)  REFERENCE  */
      IF J == 0 ;
        VRF = RF ;
      ELSE ;
        VRF = VRF|RF ;
      ENDIF ;
      J = J + 1 ;
    ENDO ;
  ELSE ;
    VRF = 0 ;
  ENDIF ;

  ND = DERIV + NI ;
  RFP = (2 * ND)! / (2^ND * ND!) ;     /*  ODD FACTORIAL(2*ND)  */
  RFP = RFP / (SQRT(PI) * 2^(ND + 1)) ;
  RFP = RFP / SD^(2*ND + 1) ;


  I = 1 ;
  DO WHILE I <= NI ;

    IF DIAGF == 0 ;
      J = 0 ;
      DO WHILE J <= NI-I ;
        H = NMI2HH(NOBS,J,KORD,VRF[1,1],VRF[J+2,1],DIAGF) ;
        VRF[J+1,1] = NMI2HBW(DIFWTS,A,B,H,J,KORD,DIAGF) ;
        J = J + 1 ;
      ENDO ;
    ENDIF ;


    ND = DERIV + NI - I ;
    H = NMI2HH(NOBS,ND,KORD,VRF[1,1],RFP,DIAGF) ;
    RFP = NMI2HBW(DIFWTS,A,B,H,ND,KORD,DIAGF) ;

    I = I + 1 ;
  ENDO ;

  RETP(RFP) ;
ENDP ;
/* ============================ END PROC NMI2ABW ======================== */
