/* =========================== START PROC NMI2H ======================== */
PROC NMI2H(DATA,H,DERIV,KORD,DIAGF) ;
    /*  THIS DOES AN EXACT CALCULATION OF A KERNEL ESTIMATE   */
    /*  OF THE INTEGRATED SQUARED DENSITY DERIVATIVE   */
    /*  THIS VERSION ONLY WORKS FOR KORD = 2   */
    /*  IF DIAGF = 0, DIAGONALS ARE LEFT OUT, OTHERWISE NOT   */
  LOCAL NOBS,D2,IOBS,IDF2,ARG,NARG,HP,HPN,M,IS ;

  NOBS = ROWS(DATA) ;

  D2 = 2 * DERIV ;

  IOBS = 1 ;
  IDF2 = 0 ;
  DO WHILE IOBS <= NOBS ;
    IF FLOOR(IOBS/10) == IOBS/10 ; "    WORKING ON OBS " IOBS ; ENDIF ;
    IF DIAGF == 0 ;
      IF IOBS == 1 ;
        ARG = DATA[2:NOBS,1] - DATA[IOBS,1] ;
      ELSEIF IOBS == NOBS ;
        ARG = DATA[1:(NOBS-1),1] - DATA[IOBS,1] ;
      ELSE ;
        ARG = (DATA[1:(IOBS-1),1]|DATA[(IOBS+1):NOBS,1]) - DATA[IOBS,1] ;
      ENDIF ;
    ELSE ;
      ARG = DATA - DATA[IOBS,1] ;
    ENDIF ;
    ARG = ARG / H ;

    NARG = NORM(ARG) ;
    HP = ONES(ROWS(ARG),COLS(ARG)) ;       /*  0TH HERMITE POLY  */
    HPN = ARG ;                         /*  1ST HERMITE POLY  */
    IS = 1 ;
    DO WHILE IS <= DERIV ;
      HP = ARG .* HPN - (2*IS - 1) * HP ;   /* (2*IS)-TH HERMITE POLY  */
      HPN = ARG .* HP - (2*IS) * HPN ;   /*  (2*IS+1)-TH HERMITE POLY  */
      IS = IS + 1 ;
    ENDO ;
    M = HP .* NARG ;

    IF IOBS == 1 ;
      IDF2 = SUMC(M) ;
    ELSE ;
      IDF2 = IDF2|SUMC(M) ;
    ENDIF ;

    IOBS = IOBS + 1 ;
  ENDO ;


  IDF2 = SUMC(IDF2) ;

  IDF2 = IDF2 / (H^(D2 + 1)) ;
  IF DIAGF == 0 ;
    IDF2 = IDF2 / (NOBS * (NOBS -1)) ;
  ELSE ;
    IDF2 = IDF2 / (NOBS * NOBS) ;
  ENDIF ;

  IDF2 = (-1)^DERIV * IDF2 ;

  RETP(IDF2) ;
ENDP ;
/* ============================ END PROC NMI2H ======================== */
