/* =========================== START PROC NMI2HB ======================== */
PROC NMI2HB(BINCTS,A,B,H,DERIV,KORD,DIAGF) ;
    /*  THIS DOES A BINNED CALCULATION OF A KERNEL ESTIMATE   */
    /*  OF THE INTEGRATED SQUARED DENSITY DERIVATIVE   */
    /*  THIS VERSION ONLY WORKS FOR KORD = 2   */
    /*  IF DIAGF = 0, DIAGONALS ARE LEFT OUT, OTHERWISE NOT   */
  LOCAL NBIN,NOBS,SH,WT,ARG,NARG,HP,HPN,IS,KERNEL,IDF2 ;

  NBIN = ROWS(BINCTS) ;
  NOBS = SUMC(BINCTS) ;

  SH = H * (NBIN / (B - A)) ;  /* SCALE H TO ADJUST FOR FUNNY DATA SCALE */

  WT = CONV(BINCTS,REV(BINCTS),NBIN,2*NBIN-1) ;
  WT[2:NBIN,1] = 2 * WT[2:NBIN,1] ;          /*  NUMBER OF OBS'S FOR EACH
                                                 KERNEL EVALUATION  */

  ARG = SEQA(0,1,NBIN) / SH ;
  NARG = NORM(ARG) ;
  HP = ONES(ROWS(ARG),COLS(ARG)) ;       /*  0TH HERMITE POLY  */
  HPN = ARG ;                         /*  1ST HERMITE POLY  */
  IS = 1 ;
  DO WHILE IS <= DERIV ;
    HP = ARG .* HPN - (2*IS - 1) * HP ;   /* (2*IS)-TH HERMITE POLY  */
    HPN = ARG .* HP - (2*IS) * HPN ;   /*  (2*IS+1)-TH HERMITE POLY  */
    IS = IS + 1 ;
  ENDO ;
  KERNEL = HP .* NARG ;


  IDF2 = WT' * KERNEL ;                         /*  INCLUSIVE DOUBLE SUM  */
  IF DIAGF == 0 ;
    IDF2 = IDF2 - NOBS * KERNEL[1,1] ;           /*  EXCLUSIVE DOUBLE SUM  */
    IDF2 = IDF2 / (NOBS * (NOBS-1) * H^(2*DERIV+1)) ;
  ELSE ;
    IDF2 = IDF2 / (NOBS * NOBS * H^(2*DERIV+1)) ;
  ENDIF ;

  IDF2 = (-1)^DERIV * IDF2 ;

  RETP(IDF2) ;
ENDP ;
/* ============================ END PROC NMI2HB ======================== */
