/* =========================== START PROC NMI2HBW ======================== */
PROC NMI2HBW(DIFWTS,A,B,H,DERIV,KORD,DIAGF) ;
    /*  THIS DOES A BINNED CALCULATION OF A KERNEL ESTIMATE   */
    /*  OF THE INTEGRATED SQUARED DENSITY DERIVATIVE   */
    /*  THE KERNEL IS  K  AS OPPOSED TO  K*K (WHICH COMES FROM  */
    /*  INTEGRATING ACTUALLY KERNEL DENSITY ESTIMATOR,  FOR K*K  */
    /*  PLUG IN BANDWIDTH TIMES SQRT(2)  */
    /*  THIS VERSION ONLY WORKS FOR KORD = 2   */
    /*  IF DIAGF = 0, DIAGONALS ARE LEFT OUT, OTHERWISE NOT   */
    /*  THIS MODIFIES NMI2HB, BY USING   */
    /*  DIFWTS, THE WEIGHTS FOR PAIRWISE DIFFERENCES, FROM NMDW.G   */
  LOCAL TRNC,NBIN,NOBS,SH,ARG,NARG,HP,HPN,IS,KERNEL,IDF2 ;

  TRNC = 10^(-25) ;     /*  FOR DIAGONALS OUT,
                               SET FINAL VALUE TO THIS IF BELOW  */
  NBIN = ROWS(DIFWTS) ;
  NOBS = SQRT(SUMC(SUMC(DIFWTS))) ;

  SH = H * (NBIN / (B - A)) ;  /* SCALE H TO ADJUST FOR FUNNY DATA SCALE */


  ARG = SEQA(0,1,NBIN) / SH ;
  NARG = NORM(ARG) ;
  HP = ONES(ROWS(ARG),COLS(ARG)) ;       /*  0TH HERMITE POLY  */
  HPN = ARG ;                         /*  1ST HERMITE POLY  */
  IS = 1 ;
  DO WHILE IS <= DERIV ;
    HP = ARG .* HPN - (2*IS - 1) * HP ;   /* (2*IS)-TH HERMITE POLY  */
    HPN = ARG .* HP - (2*IS) * HPN ;   /*  (2*IS+1)-TH HERMITE POLY  */
    IS = IS + 1 ;
  ENDO ;
  KERNEL = HP .* NARG ;


  IDF2 = DIFWTS' * KERNEL ;                         /*  INCLUSIVE DOUBLE SUM  */
  IF DIAGF == 0 ;
    IDF2 = IDF2 - NOBS * KERNEL[1,1] ;           /*  EXCLUSIVE DOUBLE SUM  */
    IDF2 = IDF2 / (NOBS * (NOBS-1) * H^(2*DERIV+1)) ;
  ELSE ;
    IDF2 = IDF2 / (NOBS * NOBS * H^(2*DERIV+1)) ;
  ENDIF ;

  IDF2 = (-1)^DERIV * IDF2 ;

  IF DIAGF == 0 ;
    IF IDF2 <= TRNC ;
      IDF2 = TRNC ;
    ENDIF ;
  ENDIF ;


  RETP(IDF2) ;
ENDP ;
/* ============================ END PROC NMI2HBW ======================== */
