/* =========================== START PROC NMI3PHI ======================== */
PROC NMI3PHI(MU1,SIG1,MU2,SIG2,MU3,SIG3) ;
    /*  THIS CALCULATES INT(PHI'' PHI''PHI) FOR  */
    /*  THE EXACT RELATIVE BANDWIDTH MSE  */
    /*  FOR A NORMAL MIXTURE DENSITY  */
    /*  REQUIRES NORM.PRC ALREADY LOADED  */
    /*  MU1,SIG1,MU2,SIG2 CAN BE COLUMN VECTORS  */
    /*  THEN OUTPUT IS SAME SIZE COLUMN */
  LOCAL S2,D,MUT,MUSS,B0,B1,B2,B3,B4,ARG,H0,H1,H2,H3,H4,OUT ;

  S2 = SQRT( (SIG1^2).*(SIG2^2) + (SIG1^2).*(SIG3^2) + (SIG2^2).*(SIG3^2) ) ;

  D = SIG1 .* SIG2 .* SIG3 ./ S2 ;

  MUT = SIG1^2 .* (MU2 - MU3)^2 ;
  MUT = MUT + SIG2^2 .* (MU1 - MU3)^2 ;
  MUT = MUT + SIG3^2 .* (MU1 - MU2)^2 ;
  MUT = SQRT(MUT) ;

  MUSS = SIG2^2 .* SIG3^2 .* MU1 ;
  MUSS = MUSS + SIG1^2 .* SIG3^2 .* MU2 ;
  MUSS = MUSS + SIG1^2 .* SIG2^2 .* MU3 ;
  MUSS = MUSS ./ S2^2 ;

  B0 = (MU1^2 - SIG1^2) .* (MU2^2 - SIG2^2) ;
  B1 = -2 .* MU1 .* (MU2^2 - SIG2^2) - 2 .* MU2 .* (MU1^2 - SIG1^2) ;
  B2 = (MU2^2 - SIG2^2) + 4 .* MU1 .* MU2 + (MU1^2 - SIG1^2) ;
  B3 = -2 .* (MU1 + MU2) ;
  B4 = 1 ;

  ARG = MUSS ./ D ;
  H0 = 1 ;
  H1 = ARG ;
  H2 = ARG^2 + 1 ;
  H3 = ARG^3 + 3.*ARG ;
  H4 = ARG^4 + 6.*ARG^2 + 3 ;

  OUT = B0 .* D^0 .* H0 ;
  OUT = OUT + B1 .* D^1 .* H1 ;
  OUT = OUT + B2 .* D^2 .* H2 ;
  OUT = OUT + B3 .* D^3 .* H3 ;
  OUT = OUT + B4 .* D^4 .* H4 ;
  OUT = OUT .* NORM(MUT ./ S2) ./ S2 ;
  OUT = OUT .* (SIG1 .* SIG2)^(-4) ./ SQRT(2 * PI) ;

  RETP(OUT) ;
ENDP ;
/* ============================ END PROC NMI3PHI ======================== */
