/* =========================== START PROC NMI4PHI ======================== */
PROC NMI4PHI(SIG1,SIG2,MU3,SIG3,MU4,SIG4) ;
    /*  THIS CALCULATES INT(PHI'' PHI'' PHI PHI) FOR  */
    /*  THE EXACT RELATIVE BANDWIDTH MSE  */
    /*  FOR A NORMAL MIXTURE DENSITY  */
    /*  REQUIRES NORM.PRC ALREADY LOADED  */
    /*  NOTE MU1 AND MU2 ARE ASSUMED TO BE 0  */
    /*  MU'S,SIG'S CAN BE COLUMN VECTORS  */
    /*  THEN OUTPUT IS SAME SIZE COLUMN */
  LOCAL S1,S2,S3,S4,D,C1,C2,M,F,E0,E1,E2,E3,E4,OUT ;

  S1 = SQRT( SIG1^2 + SIG2^2 ) ;
  S2 = SQRT( (SIG1^2).*(SIG2^2) + (SIG1^2).*(SIG3^2) + (SIG2^2).*(SIG3^2) ) ;
  S3 = SQRT( S2^2 ./ S1^2 + SIG4^2 ) ;
  S4 = S2 .* SIG4 ./ (S1.* S3) ;

  D = SIG1 .* SIG2 .* SIG3 ./ S2 ;

  C1 = SIG3^2 .* S1^2 .* S2^(-2) ./ D ;
  C2 = SIG1^2 .* SIG2^2 .* MU3 .* S2^(-2) ./ D ;

  M = ( SIG4^2 .* MU3 + S2^2 .* MU4 ./ S1^2 ) ./ S3^2 ;

  F = (SIG1 .* SIG2)^(-4) ./ SQRT(2 * PI) ;

  E0 = SIG1^2 .* SIG2^2 - (C2^2 + 1) .* (S1^2 .* D^2) ;
  E0 = E0 + (C2^4 + 6.* C2^2 + 3).*D^4 ;
   E1 = 2 .* S1^2 .* C2 .* D ;
   E1 = E1 - 2 .* C1 .* C2 .* S1^2 .* D^2 ;
   E1 = E1 - 4 .* (C2^3 + 3 .* C2) .* D^3 ;
  E1 = E1 + (4 .* C1 .* C2^3 + 12 .* C1 .* C2) .* D^4 ;
   E2 = -S1^2 + 2 .* S1^2 .* C1 .* D ;
   E2 = E2 + (6 .* C2^2 + 6 - S1^2 .* C1^2) .* D^2 ;
   E2 = E2 - 4 .* (3 .* C1 .* C2^2 + 3 .* C1) .* D^3 ;
  E2 = E2 + (6 .* C1^2 + 6 .* C1^2 .* C2^2) .* D^4 ;
   E3 = -4 .* C2 .* D + 12 .* C1 .* C2 .* D^2 ;
  E3 = E3 - 12 .* C1^2 .* C2 .* D^3 + 4 .* C1^3 .* C2 .* D^4 ;
  E4 = 1 - 4 .* C1 .* D + 6 .* C1^2 .* D^2 - 4 .* C1^3 .* D^3 + C1^4 .* D^4 ;

  OUT = E0 + M .* E1 + (M^2 + S4^2) .* E2 ;
  OUT = OUT + (M^3 + 3 .* M .* S4^2) .* E3 ;
  OUT = OUT + (M^4 + 6 .* M^2 .* S4^2 + 3 .* S4^4) .* E4 ;
  OUT = OUT .* NORM((MU3 - MU4) ./ S3) ./ S3 ;
  OUT = OUT .* F ./ S1 ;

  RETP(OUT) ;
ENDP ;
/* ============================ END PROC NMI4PHI ======================== */
