/* =========================== START PROC NMIDF2 ======================== */
PROC NMIDF2(MU,SIG2,W,NDERIV) ;
    /*  THIS CALCULATES INTEGRATED SQUARED NDERIV-TH DERIVATIVE  */
    /*  FOR A NORMAL MIXTURE DENSITY  */
    /*  NDERIV = 0,1,2...  */
    /*  REQUIRES NORM.PRC ALREADY LOADED  */
  LOCAL SLLP,ARG,H,HP,HPP,I,M,R2 ;

  R2 = 2 * NDERIV ;
  SLLP = SQRT(SIG2' + SIG2) ;
  ARG = (MU - MU') ./ SLLP ;

                /*  GENERATE HERMITE POLYNOMIALS  */
  HPP = ONES(ROWS(MU),ROWS(MU)) ;
  IF R2 == 0 ;
    H = HPP ;         /*  0TH HERMITE POLY  */
  ELSE;
    HP = ARG ;
    IF R2 == 1 ;
      H = HP ;        /*  1ST HERMITE POLY  */
    ELSE ;
      I = 2 ;
      DO WHILE I <= R2 ;
        H = ARG .* HP - (I - 1) * HPP ;   /*  ITH HERMITE POLY  */
        HPP = HP ;
        HP = H ;
        I = I + 1 ;
      ENDO ;
    ENDIF ;
  ENDIF ;
  HP = 0 ; HPP = 0 ;        /*  TO SAVE SPACE  */

  M = (-1)^R2 .* H .* NORM(ARG) ;

  M = (-1)^NDERIV .* M ./ SLLP^(R2+1) ;

  RETP(W' * M * W) ;
ENDP ;
/* ============================ END PROC NMIDF2 ======================== */
