/* =========================== START PROC NMIDF2F ======================== */
PROC NMIDF2F(MU,SIG2,W,NDERIV) ;
    /*  THIS CALCULATES INTEGRATED SQUARED NDERIV-TH DERIVATIVE, TIMES F  */
    /*  FOR A NORMAL MIXTURE DENSITY  */
    /*  NDERIV = 0,1,2...  */
    /*  REQUIRES NORM.PRC ALREADY LOADED  */
  LOCAL NM,NP,IDF2F,I,J,K,M1,M2,M3,S1,S2,S3,
               MUT,MUTT,SIGT,SIGTT,TERM,J1,J2,ARG,MHP,IP,IO2,TERMI ;

  NM = ROWS(MU) ;
  NP = NDERIV + 1 ;
  IDF2F = 0 ;

  I = 1 ;
  DO WHILE I <= NM ;

    J = 1 ;
    DO WHILE J <= NM ;

      K = 1 ;
      DO WHILE K <= NM ;

        M1 = MU[I,1] ;
        M2 = MU[J,1] ;
        M3 = MU[K,1] ;

        S1 = SQRT(SIG2[I,1]) ;
        S2 = SQRT(SIG2[J,1]) ;
        S3 = SQRT(SIG2[K,1]) ;

        MUT = ((M1 - M2) / (S1 * S2))^2 ;
        MUT = MUT + ((M1 - M3) / (S1 * S3))^2 ;
        MUT = MUT + ((M2 - M3) / (S2 * S3))^2 ;
        MUT = SQRT(MUT) ;
        SIGT = SQRT(S1^(-2) + S2^(-2) + S3^(-2)) ;
        MUTT = (M1/S1^2 + M2/S2^2 + M3/S3^2) / SIGT^2 ;
        SIGTT = 1 / SIGT ;


                /*  GENERATE HERMITE POLYNOMIALS  */
        ARG = ((M1 - MUTT) / S1)~((M2 - MUTT) / S2) ;
        MHP = ONES(1,2) ;
        IF NDERIV >= 1 ;
          MHP = MHP|ARG ;
          IP = 2 ;
          DO WHILE IP <= NP ;
            MHP = MHP|(ARG .* MHP[IP,.] - (IP - 1) .* MHP[IP-1,.]) ;
            IP = IP + 1 ;
          ENDO ;
        ENDIF ;

        TERM = 0 ;

        J1 = 0 ;
        DO WHILE J1 <= NDERIV ;

          J2 = 0 ;
          DO WHILE J2 <= NDERIV ;

            IO2 = (J1 + J2)/2 ;
            IF FLOOR(IO2) .== IO2 ;
              TERMI = NDERIV! / (J1! * (NDERIV - J1)!) ;
              TERMI = TERMI * MHP[NDERIV-J1+1,1] ;
              TERMI = TERMI * NDERIV! / (J2! * (NDERIV - J2)!) ;
              TERMI = TERMI * MHP[NDERIV-J2+1,2] ;
              TERMI = TERMI * S1^(-NDERIV-J1) ;
              TERMI = TERMI * S2^(-NDERIV-J2) ;
              TERMI = TERMI * SIGTT^(J1 + J2) ;
              TERMI = TERMI * (IO2 * 2)! / (IO2! * 2^IO2) ;

              TERM = TERM + TERMI ;
            ENDIF ;

            J2 = J2 + 1 ;
          ENDO ;

          J1 = J1 + 1 ;
        ENDO ;

        TERM = TERM / (S1 * S2 * S3) ;
        TERM = TERM * NORM(MUT / SIGT) / SIGT ;

        IDF2F = IDF2F  +  W[I,1] * W[J,1] * W[K,1] * TERM ;

        K = K + 1 ;
      ENDO ;

      J = J + 1 ;
    ENDO ;

    I = I + 1 ;
  ENDO ;

  IDF2F = IDF2F / SQRT(2 * PI) ;

  RETP(IDF2F) ;
ENDP ;
/* ============================ END PROC NMIDF2F ======================== */
