/* =========================== START PROC NMIND ======================== */
PROC NMIND(X,V,SORTFL,EPFLAG) ;
    /*  COMPUTES BIN INDICES, WHERE X'S FALL  */
    /*  V'S GIVE BIN ENDPOINTS  */
    /*  RETURNS NX-VECTOR CONTAINING BIN INDEX FOR EACH X  */
    /*  INDEX IS 0 FOR X VALUES LYING BELOW FIRST V  */
    /*  INDEX IS NV FOR X VALUES LYING ABOVE LAST V  */
    /*  SORTFL = 1 MEANS X'S NEED TO BE SORTED  */
    /*         = 0 MEANS X'S ALREADY SORTED  */
    /*  EPFLAG > 0 MEANS BIN INCLUDES RIGHT ENDPOINT  */
    /*        < 0 MEANS BIN INCLUDES LEFT ENDPOINT  */

  LOCAL NX,SX,ORIGI,CTS,MCT,I,VIND ;

  NX = ROWS(X) ;

  IF SORTFL > 0 ;
    "        SORTING X'S " ;
    SX = X~SEQA(1,1,NX) ;
    SX = SORTC(SX,1) ;
    ORIGI = SX[.,2] ;
    SX = SX[.,1] ;
  ELSE ;
    SX = X ;
    ORIGI = SEQA(1,1,NX) ;
  ENDIF ;

  CTS = NMCTS(SX,V,EPFLAG) ;

  MCT = MAXC(CTS) ;

  CTS = CTS~SEQA(0,1,ROWS(CTS)) ;
  I = 1 ;
  DO WHILE I <= MCT ;
    CTS = SELIF(CTS,(CTS[.,1] .> (I - .5))) ;

    IF I == 1 ;
      VIND = CTS[.,2] ;
    ELSE ;
      VIND = VIND|CTS[.,2] ;
    ENDIF ;

    I = I + 1 ;
  ENDO ;

  VIND = SORTC(VIND,1) ;

  IF SORTFL > 0 ;
    VIND = VIND~ORIGI ;
    VIND = SORTC(VIND,2) ;
    VIND = VIND[.,1] ;
  ENDIF ;


  RETP(VIND) ;
ENDP ;
/* ============================ END PROC NMIND ======================== */

