/* =========================== START PROC NMIPIBW ======================== */
PROC (1)=NMIPIBW(DIFWTS,A,B,SD,DIAGF,NALEV,NSTEP,HSTART) ;
    /*  THIS CALCULATES THE ITERATIVE PLUG-IN BANDWIDTH   */
    /*  FOR A GAUSSIAN KERNEL FUNCTION   */
    /*  DIAGF = 0 FOR DIAGONALS OUT VERSION  */
    /*  OHTERWISE USE SHEATHER JONES DIAGONALS IN  */
    /*  NALEV IS LEVEL OF NORMAL APPROXIMATION  */
    /*  NALEV = 1 USES PREVIOUS FHAT AT EACH STEP  */
    /*  NALEV = 2 USES N(0,S2) RESCALING OF PREVIOUS H  */
    /*  NALEV = 3 USES ITERATIONS ON 2ND DERIVATIVE  */
    /*  NALEV = 4 USES ITERATIONS ON 3RD DERIVATIVE  */
    /*  NSTEP IS NUMBER OF STEPS IN THE ITERATION  */
    /*  HSTART IS THE STARTING VALUE AT WHICH TO START ITERATING  */
    /*  NOT THE BEST FOR SPEED IN SIMULATION   */

  LOCAL  NALP1,NOBS,RK,M2,KORD,RF,RFPP,RFPPP,ILEV,G,ISTEP,HIPI ;

  NOBS = SQRT(SUMC(SUMC(DIFWTS))) ;

  M2 = 1 ;      /*  GAUSSIAN  K  */
  RK = 1 / (2* SQRT(PI)) ;
  KORD = 2 ;

  HIPI = HSTART ;
  ISTEP = 1 ;
  DO WHILE ISTEP <= NSTEP ;
    "        WORKING ON STEP " ISTEP ",   H = " HIPI ;

    IF NALEV == 1 ;
      G = HIPI * SQRT(2) ;
    ELSEIF NALEV == 2 ;
      RF = RK / SD ;
      NALP1 = 3 ;
      RFPP = (2 * NALP1)! / (2^NALP1 * NALP1!) ;
      RFPP = RFPP / (SQRT(PI) * 2^(NALP1 + 1)) ;
      RFPP = RFPP / SD^(2 * NALP1 + 1) ;
      NALP1 = 4 ;
      RFPPP = (2 * NALP1)! / (2^NALP1 * NALP1!) ;
      RFPPP = RFPPP / (SQRT(PI) * 2^(NALP1 + 1)) ;
      RFPPP = RFPPP / SD^(2 * NALP1 + 1) ;
      G = NMI2HH(NOBS,2,KORD,RF,RFPPP,DIAGF) ;
      G = G * HIPI / (RK / (M2^2 * RFPP * NOBS))^(1/5) ;
    ELSEIF NALEV == 3 ;
      G = HIPI * SQRT(2) ;
      RF = NMI2HBW(DIFWTS,A,B,G,0,KORD,DIAGF) ;
      RFPP = NMI2HBW(DIFWTS,A,B,G,2,KORD,DIAGF) ;
      G = NMI2HH(NOBS,2,KORD,RF,RFPP,DIAGF) ;
      RFPP = NMI2HBW(DIFWTS,A,B,G,2,KORD,DIAGF) ;
      G = NMI2HH(NOBS,2,KORD,RF,RFPP,DIAGF) ;
      RFPP = NMI2HBW(DIFWTS,A,B,G,2,KORD,DIAGF) ;
      G = NMI2HH(NOBS,2,KORD,RF,RFPP,DIAGF) ;
    ELSEIF NALEV == 4 ;
      G = HIPI * SQRT(2) ;
      RF = NMI2HBW(DIFWTS,A,B,G,0,KORD,DIAGF) ;
      RFPPP = NMI2HBW(DIFWTS,A,B,G,3,KORD,DIAGF) ;
      G = NMI2HH(NOBS,3,KORD,RF,RFPPP,DIAGF) ;
      RFPPP = NMI2HBW(DIFWTS,A,B,G,3,KORD,DIAGF) ;
      G = NMI2HH(NOBS,3,KORD,RF,RFPPP,DIAGF) ;
      RFPPP = NMI2HBW(DIFWTS,A,B,G,3,KORD,DIAGF) ;
      G = NMI2HH(NOBS,2,KORD,RF,RFPPP,DIAGF) ;
    ENDIF ;

    RFPP = NMI2HBW(DIFWTS,A,B,G,2,KORD,DIAGF) ;

    HIPI = RK / (M2^2 * RFPP * NOBS) ;
    IF HIPI >= .0000000001 ;
      HIPI = HIPI^(1/5) ;
    ELSE ;
     HIPI = .0000000001 ;
    ENDIF ;

    ISTEP = ISTEP + 1 ;
  ENDO ;

  RETP(HIPI) ;
ENDP;
/* ======================== END PROCEDURE NMIPIBW ======================== */
