/* =========================== START PROC NMIQR ======================== */
PROC NMIQR(V) ;
    /*  THIS FIND THE INTERQUARTILE RANGE  */
    /*  OF ENTRIES IN A COLUMN VECTOR V  */

  LOCAL NOBS,SV,K,IQR ;

  NOBS = ROWS(V) ;
  SV = SORTC(V,1) ;

  K = CEIL(NOBS/4) ;
  IF K == (NOBS/4) ;     /*  I.E. THERE IS TIE FOR QUARTILES  */
    IQR = MEANC(SV[K:(K+1),1]) ;
    IQR = MEANC(SV[(NOBS-K):(NOBS-K+1),1]) - IQR ;
  ELSE ;
    IQR = SV[K,1] ;
    IQR = SV[(NOBS-K+1),1] - IQR ;
  ENDIF ;


  RETP(IQR) ;
ENDP ;
/* ============================ END PROC NMIQR ======================== */
